/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import org.forgerock.openam.utils.Time;

public class TimeDuration {
    private long start = 0L;
    private long end = 0L;

    public void start() {
        this.end = this.start = Time.currentTimeMillis();
    }

    public void stop() {
        this.end = Time.currentTimeMillis();
    }

    public void reset() {
        this.start = 0L;
        this.end = 0L;
    }

    public long getCurrentDuration() {
        this.stop();
        return this.end - this.start;
    }

    public String toString() {
        return this.getDurationToString();
    }

    public String getDurationToString() {
        return TimeDuration.getDurationToString(this.getCurrentDuration());
    }

    public static String getDurationToString(long duration) {
        long timeInSeconds = duration / 1000L;
        if (timeInSeconds <= 0L) {
            return duration + "ms";
        }
        long milliseconds = duration - timeInSeconds * 1000L;
        long days = timeInSeconds / 86400L;
        long hours = (timeInSeconds -= days * 86400L) / 3600L;
        long minutes = (timeInSeconds -= hours * 3600L) / 60L;
        long seconds = timeInSeconds -= minutes * 60L;
        if (days > 0L) {
            return days + "d:" + hours + "h:" + minutes + "m:" + seconds + "s:" + milliseconds + "ms";
        }
        if (hours > 0L) {
            return hours + "h:" + minutes + "m:" + seconds + "s:" + milliseconds + "ms";
        }
        if (minutes > 0L) {
            return minutes + "m:" + seconds + "s:" + milliseconds + "ms";
        }
        return seconds + "s:" + milliseconds + "ms";
    }
}

