/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.TimeZone;
import org.forgerock.util.time.TimeService;
import org.joda.time.DateTimeUtils;
import org.slf4j.LoggerFactory;

public enum Time implements DateTimeUtils.MillisProvider
{
    INSTANCE;

    private final TimeService timeService;

    private Time() {
        Iterator<TimeService> services = ServiceLoader.load(TimeService.class).iterator();
        if (services.hasNext()) {
            TimeService service = services.next();
            if (services.hasNext()) {
                LoggerFactory.getLogger(Time.class).error("More than one TimeService configured in META-INF/services. Defaulting to TimeService.SYSTEM");
                this.timeService = TimeService.SYSTEM;
            } else {
                this.timeService = service;
            }
        } else {
            this.timeService = TimeService.SYSTEM;
        }
        DateTimeUtils.setCurrentMillisProvider((DateTimeUtils.MillisProvider)this);
    }

    public long getMillis() {
        return this.timeService.now();
    }

    public static long currentTimeMillis() {
        return Time.INSTANCE.timeService.now();
    }

    public static Date newDate() {
        return new Date(Time.currentTimeMillis());
    }

    public static Date newDate(long time) {
        return new Date(time);
    }

    public static Calendar getCalendarInstance() {
        Calendar calendar = Calendar.getInstance();
        return Time.setCalendarTime(calendar);
    }

    public static Calendar getCalendarInstance(Locale locale) {
        Calendar calendar = Calendar.getInstance(locale);
        return Time.setCalendarTime(calendar);
    }

    public static Calendar getCalendarInstance(TimeZone tz) {
        Calendar calendar = Calendar.getInstance(tz);
        return Time.setCalendarTime(calendar);
    }

    public static Calendar getCalendarInstance(TimeZone tz, Locale locale) {
        Calendar calendar = Calendar.getInstance(tz, locale);
        return Time.setCalendarTime(calendar);
    }

    private static Calendar setCalendarTime(Calendar calendar) {
        calendar.setTimeInMillis(Time.currentTimeMillis());
        return calendar;
    }
}

