/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import java.util.concurrent.ConcurrentHashMap;
import org.forgerock.util.Reject;

public class SingleValueMapper<K, V> {
    private final ConcurrentHashMap<K, V> map = new ConcurrentHashMap();
    private final ConcurrentHashMap<V, K> reverse = new ConcurrentHashMap();

    public V get(K k) {
        Reject.ifNull(k);
        return this.map.get(k);
    }

    public K getValue(V v) {
        Reject.ifNull(v);
        return this.reverse.get(v);
    }

    public synchronized void put(K k, V v) {
        Reject.ifNull((Object[])new Object[]{k, v});
        K previousValue = this.reverse.get(v);
        if (previousValue != null) {
            this.map.remove(previousValue);
        }
        this.map.put(k, v);
        this.reverse.put(v, k);
    }

    public synchronized V remove(K k) {
        Reject.ifNull(k);
        V remove = this.map.remove(k);
        this.reverse.remove(remove);
        return remove;
    }
}

