/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.forgerock.openam.utils.PerThreadCache;
import org.forgerock.openam.utils.SAXParserProvider;
import org.xml.sax.SAXException;

class PerThreadSAXParserProvider
implements SAXParserProvider {
    private static final int DEFAULT_CACHE_SIZE = 500;
    private final PerThreadSAXParserCache validatingParserCache;
    private final PerThreadSAXParserCache nonValidatingParserCache;

    PerThreadSAXParserProvider(SAXParserProvider delegate, int maxSize) {
        if (delegate == null) {
            throw new NullPointerException("Delegate SAXParserProvider cannot be null");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be > 0");
        }
        this.validatingParserCache = new PerThreadSAXParserCache(maxSize, true, delegate);
        this.nonValidatingParserCache = new PerThreadSAXParserCache(maxSize, false, delegate);
    }

    PerThreadSAXParserProvider(SAXParserProvider delegate) {
        this(delegate, 500);
    }

    @Override
    public SAXParser getSAXParser(boolean validating) throws ParserConfigurationException, SAXException {
        try {
            return validating ? (SAXParser)this.validatingParserCache.getInstanceForCurrentThread() : (SAXParser)this.nonValidatingParserCache.getInstanceForCurrentThread();
        }
        catch (SAXException ex) {
            if (ex.getCause() instanceof ParserConfigurationException) {
                throw (ParserConfigurationException)ex.getCause();
            }
            throw ex;
        }
    }

    private static class PerThreadSAXParserCache
    extends PerThreadCache<SAXParser, SAXException> {
        private final boolean validating;
        private final SAXParserProvider delegate;

        PerThreadSAXParserCache(int maxSize, boolean validating, SAXParserProvider delegate) {
            super(maxSize);
            this.validating = validating;
            this.delegate = delegate;
        }

        @Override
        protected SAXParser initialValue() throws SAXException {
            try {
                return this.delegate.getSAXParser(this.validating);
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException(ex);
            }
        }
    }
}

