/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.forgerock.openam.utils.DocumentBuilderProvider;
import org.forgerock.openam.utils.PerThreadCache;

class PerThreadDocumentBuilderProvider
implements DocumentBuilderProvider {
    private static final int DEFAULT_CACHE_SIZE = 500;
    private final PerThreadCache<DocumentBuilder, ParserConfigurationException> validatingDBCache;
    private final PerThreadCache<DocumentBuilder, ParserConfigurationException> nonValidatingDBCache;

    PerThreadDocumentBuilderProvider(DocumentBuilderProvider delegate, int maxSize) {
        if (delegate == null) {
            throw new NullPointerException("Delegate DocumentBuilderProvider cannot be null");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("MaxSize must be positive");
        }
        this.validatingDBCache = new PerThreadDBCache(delegate, true, maxSize);
        this.nonValidatingDBCache = new PerThreadDBCache(delegate, false, maxSize);
    }

    PerThreadDocumentBuilderProvider(DocumentBuilderProvider delegate) {
        this(delegate, 500);
    }

    @Override
    public DocumentBuilder getDocumentBuilder(boolean validating) throws ParserConfigurationException {
        return validating ? this.validatingDBCache.getInstanceForCurrentThread() : this.nonValidatingDBCache.getInstanceForCurrentThread();
    }

    private static final class PerThreadDBCache
    extends PerThreadCache<DocumentBuilder, ParserConfigurationException> {
        private final DocumentBuilderProvider delegate;
        private final boolean validating;

        private PerThreadDBCache(DocumentBuilderProvider delegate, boolean validating, int maxSize) {
            super(maxSize);
            this.validating = validating;
            this.delegate = delegate;
        }

        @Override
        protected DocumentBuilder initialValue() throws ParserConfigurationException {
            return this.delegate.getDocumentBuilder(this.validating);
        }
    }
}

