/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import com.sun.identity.shared.debug.Debug;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class PerThreadCache<T, E extends Exception> {
    private static final Debug DEBUG = Debug.getInstance("amUtil");
    private static final int INITIAL_CACHE_SIZE = 16;
    private static final float CACHE_LOAD_FACTOR = 0.75f;
    private final int maxSize;
    private final Map<Long, T> cache = new LinkedHashMap<Long, T>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, T> eldestEntry) {
            boolean remove;
            boolean bl = remove = this.size() > PerThreadCache.this.maxSize;
            if (remove && DEBUG.warningEnabled()) {
                Object value = eldestEntry.getValue();
                String name = value == null ? "null" : value.getClass().getName();
                DEBUG.warning("Cache size limit [" + PerThreadCache.this.maxSize + "] exceeded: evicting eldest entry: " + name);
            }
            return remove;
        }
    };

    public PerThreadCache(int maxSize) {
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getInstanceForCurrentThread() throws E {
        T result;
        long threadId = Thread.currentThread().getId();
        Map<Long, T> map = this.cache;
        synchronized (map) {
            result = this.cache.get(threadId);
        }
        if (result == null) {
            result = this.initialValue();
            map = this.cache;
            synchronized (map) {
                this.cache.put(threadId, result);
            }
        }
        return result;
    }

    protected abstract T initialValue() throws E;
}

