/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.forgerock.api.jackson.JacksonUtils;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.openam.utils.JsonObject;

public final class JsonValueBuilder {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonValueBuilder() {
    }

    public static JsonObject jsonValue() {
        return new JsonObject();
    }

    public static JsonValue toJsonValue(String json) throws JsonException {
        try {
            return new JsonValue(MAPPER.readValue(json, Map.class));
        }
        catch (IOException e) {
            throw new JsonException("Failed to parse json", (Throwable)e);
        }
    }

    public static JsonValue toJsonValue(byte[] json) throws JsonException {
        try {
            return new JsonValue(MAPPER.readValue(json, Map.class));
        }
        catch (IOException e) {
            throw new JsonException("Failed to parse json", (Throwable)e);
        }
    }

    public static JsonValue toJsonArray(String json) throws JsonException {
        try {
            return new JsonValue(MAPPER.readValue(json, List.class));
        }
        catch (IOException e) {
            throw new JsonException("Failed to parse json", (Throwable)e);
        }
    }

    public static JsonValue toJsonArray(InputStream json) throws JsonException {
        try {
            return new JsonValue(MAPPER.readValue(json, List.class));
        }
        catch (IOException e) {
            throw new JsonException("Failed to parse json", (Throwable)e);
        }
    }

    public static JsonValue fromResource(Class<?> relativeType, String resource) {
        InputStream resource1 = relativeType.getResourceAsStream(resource);
        try {
            return JsonValue.json((Object)JacksonUtils.OBJECT_MAPPER.readValue(resource1, Object.class));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read declared resource " + resource, e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return MAPPER;
    }
}

