/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.forgerock.openam.utils.CollectionUtils;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.util.Reject;

public final class IOUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final int BUFFER_SIZE = 8192;

    private IOUtils() {
    }

    public static String getFileContent(String path) throws IOException {
        return IOUtils.getFileContent(path, DEFAULT_ENCODING);
    }

    public static String getFileContent(String path, String encoding) throws IOException {
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("The supplied file: " + path + " either does not exists, or is not readable");
        }
        return IOUtils.readStream(new FileInputStream(file), encoding);
    }

    public static String getFileContentFromClassPath(Class classInSameModule, String path) throws IOException {
        return IOUtils.getFileContentFromClassPath(classInSameModule, path, DEFAULT_ENCODING);
    }

    public static String getFileContentFromClassPath(Class classInSameModule, String path, String encoding) throws IOException {
        InputStream is = classInSameModule.getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException("The supplied file: " + path + " is missing from the classpath");
        }
        return IOUtils.readStream(is, encoding);
    }

    public static String readStream(InputStream is) throws IOException {
        return IOUtils.readStream(is, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStream(InputStream is, String encoding) throws IOException {
        StringBuilder content = new StringBuilder();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, encoding));
            while ((line = br.readLine()) != null) {
                content.append(line).append('\n');
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeIfNotNull(br);
            throw throwable;
        }
        IOUtils.closeIfNotNull((Closeable)br);
        return content.toString();
    }

    public static void writeToFile(String fileName, String content) throws IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(fileName);
            fileWriter.write(content);
        }
        catch (Throwable throwable) {
            IOUtils.closeIfNotNull(fileWriter);
            throw throwable;
        }
        IOUtils.closeIfNotNull((Closeable)fileWriter);
    }

    public static void closeIfNotNull(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeIfNotNull(Closeable ... o) {
        if (o == null) {
            return;
        }
        for (Closeable c : o) {
            IOUtils.closeIfNotNull(c);
        }
    }

    public static long copyStream(InputStream in, OutputStream out) throws IOException {
        Reject.ifNull((Object[])new Closeable[]{in, out});
        byte[] buffer = new byte[8192];
        long bytesCopied = 0L;
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            bytesCopied += (long)bytesRead;
            bytesRead = in.read(buffer);
        }
        return bytesCopied;
    }

    public static <T> T deserialise(byte[] bytes, boolean compressed) throws IOException, ClassNotFoundException {
        return IOUtils.deserialise(bytes, compressed, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserialise(byte[] bytes, boolean compressed, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Object result;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        WhitelistObjectInputStream ois = compressed ? new WhitelistObjectInputStream(new InflaterInputStream(bais), classLoader) : new WhitelistObjectInputStream(bais, classLoader);
        try {
            result = ois.readObject();
        }
        finally {
            IOUtils.closeIfNotNull((Closeable)ois);
        }
        return (T)result;
    }

    private static class WhitelistObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;
        private final List<String> classWhitelist;
        private static final Debug DEBUG = Debug.getInstance("amUtil");
        private static final String ARRAY_FLAG = "[";
        private static final List<String> FALLBACK_CLASS_WHITELIST = Arrays.asList("com.iplanet.dpro.session.DNOrIPAddressListTokenRestriction", "com.sun.identity.console.base.model.SMSubConfig", "com.sun.identity.console.service.model.SMDescriptionData", "com.sun.identity.console.service.model.SMDiscoEntryData", "com.sun.identity.console.session.model.SMSessionData", "com.sun.identity.shared.datastruct.OrderedSet", "com.sun.xml.bind.util.ListImpl", "com.sun.xml.bind.util.ProxyListImpl", "java.lang.Boolean", "java.lang.Integer", "java.lang.Number", "java.lang.String", "java.net.InetAddress", "java.util.ArrayList", "java.util.Collections$EmptyMap", "java.util.Collections$SingletonList", "java.util.HashMap", "java.util.LinkedHashMap", "java.util.Collections$UnmodifiableMap", "java.util.TreeSet", "java.lang.String$CaseInsensitiveComparator", "java.util.TreeMap", "java.util.HashSet", "org.forgerock.openam.dpro.session.NoOpTokenRestriction", "org.apache.catalina.util.ParameterMap", "javax.servlet.DispatcherType", "java.lang.Enum", "org.forgerock.openam.authentication.service.protocol.RemoteHttpServletRequest", "org.forgerock.openam.authentication.service.protocol.RemoteHttpServletResponse", "org.forgerock.openam.authentication.service.protocol.RemoteServletRequest", "org.forgerock.openam.authentication.service.protocol.RemoteServletResponse", "java.util.Locale", "org.forgerock.openam.authentication.service.protocol.RemoteCookie", "com.sun.identity.common.CaseInsensitiveHashSet", "com.sun.identity.common.CaseInsensitiveKey", "com.sun.identity.common.CaseInsensitiveHashMap", "org.forgerock.openam.authentication.service.protocol.RemoteSession", "java.lang.StringBuffer");

        public WhitelistObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
            String property = SystemPropertiesManager.get("openam.deserialisation.classes.whitelist");
            List<String> list = this.classWhitelist = StringUtils.isEmpty(property) ? FALLBACK_CLASS_WHITELIST : CollectionUtils.asList(property.split(","));
            if (DEBUG.messageEnabled()) {
                DEBUG.message("WhitelistObjectInputStream: using class whitelist:" + this.classWhitelist);
            }
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String classToLoad = desc.getName();
            if (!this.isValidClass(classToLoad)) {
                DEBUG.warning("WhitelistObjectInputStream.resolveClass:" + classToLoad + " was not in the whitelist of allowed classes");
                throw new InvalidClassException(classToLoad, "Requested ObjectStreamClass was not in the whitelist of allowed classes");
            }
            Class<?> result = this.classLoader == null ? Class.forName(classToLoad) : Class.forName(classToLoad, true, this.classLoader);
            return result;
        }

        private boolean isValidClass(String classToLoad) {
            boolean result;
            boolean bl = result = classToLoad.startsWith(ARRAY_FLAG) || this.classWhitelist.contains(classToLoad);
            if (DEBUG.messageEnabled()) {
                DEBUG.message("WhitelistObjectInputStream.isValidClass:" + classToLoad + " " + result);
            }
            return result;
        }
    }
}

