/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

public final class AttributeUtils {
    public static final String STATIC_QUOTE = "\"";
    public static final String BINARY_FLAG = ";binary";

    private AttributeUtils() {
    }

    public static boolean isStaticAttribute(String attributeName) {
        return attributeName != null && attributeName.startsWith(STATIC_QUOTE) && attributeName.endsWith(STATIC_QUOTE);
    }

    public static String removeStaticAttributeFlag(String attributeName) {
        if (AttributeUtils.isStaticAttribute(attributeName)) {
            return attributeName.substring(STATIC_QUOTE.length(), attributeName.length() - STATIC_QUOTE.length());
        }
        return attributeName;
    }

    public static boolean isBinaryAttribute(String attributeName) {
        return attributeName != null && attributeName.endsWith(BINARY_FLAG);
    }

    public static String removeBinaryAttributeFlag(String attributeName) {
        if (AttributeUtils.isBinaryAttribute(attributeName)) {
            return attributeName.substring(0, attributeName.lastIndexOf(BINARY_FLAG));
        }
        return attributeName;
    }
}

