/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.security.whitelist;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.whitelist.URLPatternMatcher;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.forgerock.json.JsonValue;
import org.forgerock.openam.shared.security.whitelist.ValidDomainExtractor;
import org.forgerock.openam.utils.StringUtils;

public class RedirectUrlValidator<T> {
    public static final String GOTO = "goto";
    public static final String GOTO_ON_FAIL = "gotoOnFail";
    private static final Debug DEBUG = Debug.getInstance("patternMatching");
    private final ValidDomainExtractor<T> domainExtractor;
    private static final String MAX_URL_LENGTH_PROPERTY = "org.forgerock.openam.redirecturlvalidator.maxUrlLength";
    private static final int MAX_URL_LENGTH = SystemPropertiesManager.getAsInt("org.forgerock.openam.redirecturlvalidator.maxUrlLength", 2000);

    public RedirectUrlValidator(ValidDomainExtractor<T> domainExtractor) {
        this.domainExtractor = domainExtractor;
    }

    public boolean isRedirectUrlValid(String url, T configInfo) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        Collection<String> patterns = this.domainExtractor.extractValidDomains(configInfo);
        DEBUG.message("RedirectUrlValidator.isRedirectUrlValid: Validating goto URL {} against patterns: {}", url, patterns);
        if (url.length() > MAX_URL_LENGTH) {
            DEBUG.message("RedirectUrlValidator.isRedirectUrlValid: The url was length {} which is longer than the allowed maximum of {}", url.length(), MAX_URL_LENGTH);
            return false;
        }
        try {
            URI uri = new URI(url);
            if (!uri.isAbsolute() && !url.startsWith("//")) {
                return true;
            }
            if (uri.getScheme() != null && !uri.getScheme().equals("http") && !uri.getScheme().equals("https")) {
                return false;
            }
        }
        catch (URISyntaxException urise) {
            DEBUG.message("RedirectUrlValidator.isRedirectUrlValid: The goto URL {} is not a valid URI", url, urise);
            return false;
        }
        if (patterns == null || patterns.isEmpty()) {
            DEBUG.message("RedirectUrlValidator.isRedirectUrlValid: There are no patterns to validate the URL against, the goto URL {} is considered valid", url);
            return true;
        }
        URLPatternMatcher patternMatcher = new URLPatternMatcher();
        try {
            return patternMatcher.match(url, patterns, true);
        }
        catch (MalformedURLException murle) {
            DEBUG.error("RedirectUrlValidator.isRedirectUrlValid: An error occurred while validating goto URL: {}", url, murle);
            return false;
        }
    }

    public String getRedirectUrl(T configInfo, String gotoUrl, String alternateUrl) {
        String returnValue = null;
        if (gotoUrl == null) {
            return alternateUrl;
        }
        if (this.isRedirectUrlValid(gotoUrl, configInfo)) {
            returnValue = gotoUrl;
        }
        if (returnValue == null || returnValue.isEmpty()) {
            returnValue = alternateUrl;
        }
        return returnValue;
    }

    public String getAndDecodeParameter(HttpServletRequest request, String paramName) {
        String value = request.getParameter(paramName);
        if (value == null) {
            return null;
        }
        String encoded = request.getParameter("encoded");
        if (Boolean.parseBoolean(encoded)) {
            String decodedParameterValue = Base64.decodeAsUTF8String(value);
            if (decodedParameterValue == null) {
                DEBUG.warning("RedirectUrlValidator.getAndDecodeParameter: As parameter 'encoded' is true, parameter ['{}']='{}' should be base64 encoded", paramName, value);
            }
            return decodedParameterValue;
        }
        return value;
    }

    public String getValueFromJson(JsonValue input, String paramName) {
        if (input == null || !input.isDefined(paramName)) {
            return null;
        }
        return input.get(paramName).asString();
    }
}

