/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.security.crypto;

import com.iplanet.services.util.ConfigurableKey;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.util.Reject;
import org.forgerock.util.annotations.VisibleForTesting;

public class PBKDF2KeyDerivation
implements ConfigurableKey {
    private static final int SALT_BYTES = 16;
    private static final String DIGEST_ALGORITHM_PROPERTY = "org.forgerock.openam.encryption.key.digest";
    private static final String ITERATIONS_PROPERTY = "org.forgerock.openam.encryption.key.iterations";
    private final int iterations;
    private final SecretKeyFactory secretKeyFactory;
    private final SecureRandom secureRandom = new SecureRandom();
    private volatile char[] password;

    @VisibleForTesting
    PBKDF2KeyDerivation(String messageDigest, int iterations) {
        Reject.rejectStateIfTrue((iterations < 10000 ? 1 : 0) != 0, (String)"Should use at least 10,000 iterations");
        this.iterations = iterations;
        try {
            this.secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmac" + messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Invalid message digest: " + messageDigest, e);
        }
    }

    public PBKDF2KeyDerivation() {
        this(SystemPropertiesManager.get(DIGEST_ALGORITHM_PROPERTY, "SHA1"), SystemPropertiesManager.getAsInt(ITERATIONS_PROPERTY, 10000));
    }

    @Override
    public void setPassword(String password) throws Exception {
        Reject.ifTrue((boolean)StringUtils.isBlank(password));
        char[] oldPassword = this.password;
        if (oldPassword != null) {
            Arrays.fill(oldPassword, ' ');
        }
        this.password = password.toCharArray();
    }

    public PBEKey deriveSecretKey(int keySize) {
        byte[] salt = new byte[16];
        this.secureRandom.nextBytes(salt);
        return this.deriveSecretKey(keySize, salt);
    }

    public PBEKey deriveSecretKey(int keySize, byte[] salt) {
        Reject.ifNull((Object)salt);
        Reject.ifTrue((salt.length < 16 ? 1 : 0) != 0, (String)"Salt should be at least 16 bytes");
        Reject.rejectStateIfTrue((this.password == null ? 1 : 0) != 0, (String)"No password configured");
        try {
            return (PBEKey)this.secretKeyFactory.generateSecret(new PBEKeySpec(this.password, salt, this.iterations, keySize));
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid key size", e);
        }
    }

    public void clear() {
        Arrays.fill(this.password, ' ');
        this.password = null;
    }
}

