/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.security.crypto;

import com.sun.identity.shared.debug.Debug;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Arrays;
import org.forgerock.openam.shared.security.crypto.KeyStoreType;
import org.forgerock.openam.utils.IOUtils;
import org.forgerock.util.Reject;

public final class KeyStoreBuilder {
    private static final Debug DEBUG = Debug.getInstance("amSecurity");
    private KeyStoreType type = KeyStoreType.JKS;
    private InputStream inputStream = null;
    private Provider provider = null;
    private char[] password = null;

    public KeyStoreBuilder withInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public KeyStoreBuilder withKeyStoreFile(File keyStoreFile) throws FileNotFoundException {
        return this.withInputStream(new FileInputStream(keyStoreFile));
    }

    public KeyStoreBuilder withKeyStoreType(KeyStoreType type) {
        this.type = (KeyStoreType)((Object)Reject.checkNotNull((Object)((Object)type)));
        return this;
    }

    public KeyStoreBuilder withPassword(char[] password) {
        this.password = password;
        return this;
    }

    public KeyStoreBuilder withPassword(String password) {
        return this.withPassword(password.toCharArray());
    }

    public KeyStoreBuilder withProvider(Provider provider) {
        Reject.ifNull((Object)provider);
        this.provider = provider;
        return this;
    }

    public KeyStoreBuilder withProvider(String providerName) {
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new IllegalArgumentException("No such provider: " + providerName);
        }
        return this.withProvider(provider);
    }

    public KeyStore build() {
        try {
            KeyStore keyStore = this.provider != null ? KeyStore.getInstance(this.type.toString(), this.provider) : KeyStore.getInstance(this.type.toString());
            keyStore.load(this.inputStream, this.password);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            DEBUG.error("KeyStoreBuilder.build(): Error loading keystore", e);
            throw new IllegalStateException("Unable to load keystore");
        }
        finally {
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
            }
            IOUtils.closeIfNotNull((Closeable)this.inputStream);
        }
    }
}

