/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.security.crypto;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Singleton;
import org.forgerock.openam.shared.security.crypto.KeyPairProvider;
import org.forgerock.openam.shared.security.crypto.KeyPairProviderFactory;
import org.forgerock.openam.shared.security.crypto.KeyPairProviderImpl;

@Singleton
public final class KeyPairProviderFactoryImpl
implements KeyPairProviderFactory {
    private final ConcurrentMap<String, KeyPairProvider> providerCache = new ConcurrentHashMap<String, KeyPairProvider>();

    @Override
    public KeyPairProvider getProvider(String realm) {
        KeyPairProvider existingProvider;
        KeyPairProvider provider = (KeyPairProvider)this.providerCache.get(realm);
        if (provider == null && (existingProvider = this.providerCache.putIfAbsent(realm, provider = new KeyPairProviderImpl())) != null) {
            provider = existingProvider;
        }
        return provider;
    }
}

