/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.resourcename;

import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.forgerock.openam.shared.resourcename.BasePrefixResourceName;

public abstract class BaseURLResourceName<T, E extends Exception>
extends BasePrefixResourceName<T, E> {
    protected static Comparator<String> comparator = new QueryParameterComparator();
    private static final String QUERY_PARAMETER_DELIMITER = "&";
    private static final String QUERY_PARAMETER_VALUE_DELIMITER = "=";
    private static final String COLON = ":";
    private static final String SCHEME_DELIMITER = "://";
    private static final String SLASH = "/";
    private static final String QUERY_DELIMITER = "?";
    private static final String DEFAULT_WEB_PROTOCOL = "http";
    private static final String SECURE_WEB_PROTOCOL = "https";
    private static final String DEFAULT_PORT = "80";
    private static final String SECURE_PORT = "443";
    private static final String WILDCARD = "*";
    private static final Pattern ACCEPTABLE_URLS = Pattern.compile("^(http|https)\\**://.*$");

    protected BaseURLResourceName(Debug debug, T exactMatch, T noMatch, T subResourceMatch, T superResourceMatch, T wildcardMatch) {
        super(debug, exactMatch, noMatch, subResourceMatch, superResourceMatch, wildcardMatch);
    }

    @Override
    public T compare(String requestResource, String targetResource, boolean wildcardCompare) {
        if (!wildcardCompare) {
            return super.compare(requestResource, targetResource, wildcardCompare);
        }
        String schemelessTarget = targetResource;
        String schemelessRequest = requestResource;
        if (!schemelessTarget.contains(SCHEME_DELIMITER) || !schemelessRequest.contains(SCHEME_DELIMITER)) {
            return super.compare(requestResource, targetResource, wildcardCompare);
        }
        schemelessTarget = this.removeSchemeEnsureSlash(schemelessTarget);
        schemelessRequest = this.removeSchemeEnsureSlash(schemelessRequest);
        int firstColon = schemelessTarget.indexOf(COLON);
        int firstSlash = schemelessTarget.indexOf(SLASH);
        if (firstColon == -1) {
            return super.compare(requestResource, targetResource, wildcardCompare);
        }
        T schemeMatch = this.compareBeforeBreakpoint(requestResource, targetResource, SCHEME_DELIMITER);
        if (!this.isSuccessfulMatch(schemeMatch)) {
            return (T)this.noMatch;
        }
        if (firstSlash >= 0 && firstSlash < firstColon) {
            return super.compare(schemelessRequest, schemelessTarget, wildcardCompare);
        }
        if (firstSlash >= 0 && firstSlash > firstColon) {
            String postColonTarget;
            T hostMatch = this.compareBeforeBreakpoint(schemelessRequest, schemelessTarget, COLON);
            if (!this.isSuccessfulMatch(hostMatch)) {
                return (T)this.noMatch;
            }
            String postColonRequest = schemelessRequest.substring(schemelessRequest.indexOf(COLON));
            T portMatch = this.compareBeforeBreakpoint(postColonRequest, postColonTarget = schemelessTarget.substring(schemelessTarget.indexOf(COLON)), SLASH);
            if (!this.isSuccessfulMatch(portMatch)) {
                return (T)this.noMatch;
            }
            String postSlashRequest = postColonRequest.substring(postColonRequest.indexOf(SLASH));
            String postSlashTarget = postColonTarget.substring(postColonTarget.indexOf(SLASH));
            int requestQueryStringIndex = postSlashRequest.indexOf(QUERY_DELIMITER);
            int targetQueryStringIndex = postSlashTarget.indexOf(QUERY_DELIMITER);
            if (requestQueryStringIndex != -1) {
                if (targetQueryStringIndex == -1) {
                    String preQueryStringRequest = postSlashRequest.substring(0, requestQueryStringIndex);
                    Object pathMatch = super.compare(preQueryStringRequest, postSlashTarget, wildcardCompare);
                    if (this.noMatch.equals(pathMatch) || this.subResourceMatch.equals(pathMatch)) {
                        return (T)this.noMatch;
                    }
                    return (T)this.superResourceMatch;
                }
                T pathMatch = this.compareBeforeBreakpoint(postSlashRequest, postSlashTarget, QUERY_DELIMITER);
                if (!this.isSuccessfulMatch(pathMatch)) {
                    return (T)this.noMatch;
                }
                Object queryMatch = super.compare(postSlashRequest.substring(requestQueryStringIndex), postSlashTarget.substring(targetQueryStringIndex), wildcardCompare);
                return (T)this.wildcardResponseCombiner(hostMatch, portMatch, pathMatch, queryMatch);
            }
            Object pathMatch = super.compare(postSlashRequest, postSlashTarget, wildcardCompare);
            return (T)this.wildcardResponseCombiner(hostMatch, portMatch, pathMatch);
        }
        return this.compareSplit(schemelessRequest, schemelessTarget, COLON);
    }

    private boolean isSuccessfulMatch(T matchResult) {
        return this.exactMatch.equals(matchResult) || this.wildcardMatch.equals(matchResult);
    }

    private T compareSplit(String resource, String target, String breakPoint) {
        if (!resource.contains(breakPoint)) {
            return super.compare(resource, target, true);
        }
        T firstMatch = this.compareBeforeBreakpoint(resource, target, breakPoint);
        if (this.noMatch.equals(firstMatch) || this.subResourceMatch.equals(firstMatch)) {
            return firstMatch;
        }
        T secondMatch = this.compareAfterBreakpoint(resource, target, breakPoint);
        return (T)this.wildcardResponseCombiner(firstMatch, secondMatch);
    }

    private T wildcardResponseCombiner(T ... matches) {
        boolean wildcard = false;
        for (T match : matches) {
            if (this.wildcardMatch.equals(match)) {
                wildcard = true;
                continue;
            }
            if (this.exactMatch.equals(match)) continue;
            return match;
        }
        if (wildcard) {
            return (T)this.wildcardMatch;
        }
        return (T)this.exactMatch;
    }

    private T compareBeforeBreakpoint(String resource, String target, String breakPoint) {
        int firstResourceBreakPoint = resource.indexOf(breakPoint);
        int firstTargetBreakPoint = target.indexOf(breakPoint);
        if (firstResourceBreakPoint == -1 || firstTargetBreakPoint == -1) {
            return super.compare(resource, target, true);
        }
        String resourceSub = resource.substring(0, firstResourceBreakPoint);
        String targetSub = target.substring(0, firstTargetBreakPoint);
        if (targetSub.endsWith(this.wildcard)) {
            return super.compare(resourceSub, targetSub, true);
        }
        return this.compareSplit(resourceSub, targetSub, breakPoint);
    }

    private T compareAfterBreakpoint(String resource, String target, String breakPoint) {
        int firstResourceBreakPoint = resource.indexOf(breakPoint);
        int firstTargetBreakPoint = target.indexOf(breakPoint);
        if (firstResourceBreakPoint == -1 || firstTargetBreakPoint == -1) {
            return super.compare(resource, target, true);
        }
        String resourceSub = resource.substring(firstResourceBreakPoint + breakPoint.length());
        String targetSub = target.substring(firstTargetBreakPoint + breakPoint.length());
        if (targetSub.endsWith(this.wildcard)) {
            return super.compare(resourceSub, targetSub, true);
        }
        return this.compareSplit(resourceSub, targetSub, breakPoint);
    }

    private String removeSchemeEnsureSlash(String url) {
        String part = url.substring(url.indexOf(SCHEME_DELIMITER) + SCHEME_DELIMITER.length());
        if (!part.contains(SLASH)) {
            return part + SLASH;
        }
        return part;
    }

    @Override
    public String canonicalize(String urlStr) throws E {
        String resource;
        if (!ACCEPTABLE_URLS.matcher(urlStr).matches()) {
            return super.canonicalize(urlStr);
        }
        int index = urlStr.indexOf(SCHEME_DELIMITER);
        String proto = urlStr.substring(0, index);
        String hostAndPort = resource = urlStr.substring(index + 3);
        String urlPath = "";
        if (resource.startsWith(this.delimiter)) {
            int j;
            int len = resource.length();
            char[] oldchars = resource.toCharArray();
            char[] newchars = new char[len];
            for (j = 0; j < len && oldchars[j] == this.delimiter.charAt(0); ++j) {
            }
            int i = 0;
            while (j < len) {
                newchars[i++] = oldchars[j++];
            }
            resource = String.valueOf(newchars, 0, i);
        }
        String hostName = "";
        String port = "";
        String query = null;
        if (resource != null && resource.length() != 0) {
            index = resource.indexOf(47);
            if (index == -1) {
                index = resource.indexOf(63);
            }
            if (index != -1) {
                hostAndPort = resource.substring(0, index);
                urlPath = resource.substring(index);
            }
            hostName = hostAndPort;
            index = hostAndPort.indexOf(58);
            if (index != -1) {
                hostName = hostAndPort.substring(0, index);
                port = hostAndPort.substring(index + 1);
                this.validatePort(port);
            }
            if ((index = urlPath.indexOf(63)) != -1) {
                query = urlPath.substring(index + 1);
            }
            if (port.length() == 0) {
                port = proto.equals(DEFAULT_WEB_PROTOCOL) ? DEFAULT_PORT : (proto.equals(SECURE_WEB_PROTOCOL) ? SECURE_PORT : this.wildcard);
            }
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(proto);
        sb.append(SCHEME_DELIMITER);
        sb.append(hostName);
        if (hostName.length() != 0) {
            sb.append(COLON);
            sb.append(port);
            if (hostName.equals(this.wildcard) && hostAndPort.equals(this.wildcard) && resource.equals(this.wildcard)) {
                sb.append(this.wildcard);
            }
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("URLResourceName: url query=" + query);
        }
        if (query != null) {
            int indexQuery = urlPath.lastIndexOf(query);
            String prefix = super.canonicalize(urlPath.substring(0, indexQuery - 1));
            sb.append(prefix);
            sb.append('?');
            int indexAmp = query.indexOf(QUERY_PARAMETER_DELIMITER);
            if (indexAmp != -1) {
                String suffix = urlPath.substring(indexQuery + query.length());
                ArrayList<String> al = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(query, QUERY_PARAMETER_DELIMITER);
                while (st.hasMoreTokens()) {
                    al.add(st.nextToken());
                }
                Collections.sort(al, comparator);
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    if (i < size - 1) {
                        sb.append((String)al.get(i)).append(QUERY_PARAMETER_DELIMITER);
                        continue;
                    }
                    sb.append((String)al.get(i));
                }
                sb.append(suffix);
            } else {
                sb.append(query);
            }
        } else {
            sb.append(super.canonicalize(urlPath));
        }
        return sb.toString();
    }

    private void validatePort(String port) throws E {
        String portString = port;
        int idx = port.indexOf(this.wildcard);
        if (idx != -1) {
            int begin = 0;
            int wildcardLen = this.wildcard.length();
            StringBuilder sb = new StringBuilder(100);
            while (idx != -1) {
                sb.append(port.substring(begin, idx));
                begin = idx + wildcardLen;
                idx = port.indexOf(this.wildcard, begin);
            }
            sb.append(port.substring(begin));
            portString = sb.toString();
        }
        if (portString != null && portString.length() != 0) {
            try {
                Integer.parseInt(portString);
            }
            catch (Exception e) {
                Object[] objs = new String[]{port};
                throw this.constructResourceInvalidException(objs);
            }
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("URLResourceName: portString = " + portString);
        }
    }

    private static final class QueryParameterComparator
    implements Comparator<String> {
        private QueryParameterComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int result;
            if (s1 == null) {
                if (s2 != null) {
                    return -1;
                }
                return 0;
            }
            if (s2 == null) {
                return 1;
            }
            String var1 = s1;
            String value1 = null;
            String var2 = s2;
            String value2 = null;
            int index1 = s1.indexOf(BaseURLResourceName.QUERY_PARAMETER_VALUE_DELIMITER);
            int index2 = s2.indexOf(BaseURLResourceName.QUERY_PARAMETER_VALUE_DELIMITER);
            if (index1 != -1) {
                var1 = s1.substring(0, index1);
                value1 = s1.substring(index1);
            }
            if (index2 != -1) {
                var2 = s2.substring(0, index2);
                value2 = s2.substring(index2);
            }
            if ((result = var1.compareTo(var2)) == 0) {
                result = value1 == null ? (value2 != null ? -1 : 0) : (value2 == null ? 1 : value1.compareTo(value2));
            }
            if (BaseURLResourceName.WILDCARD.equals(var1)) {
                return 1;
            }
            if (BaseURLResourceName.WILDCARD.equals(var2)) {
                return -1;
            }
            return result;
        }
    }
}

