/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.resourcename;

import com.sun.identity.shared.debug.Debug;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.forgerock.openam.shared.resourcename.BaseResourceName;

public abstract class BasePrefixResourceName<T, E extends Exception>
implements BaseResourceName<T, E> {
    protected final T wildcardMatch;
    protected final T superResourceMatch;
    protected final T subResourceMatch;
    protected final T noMatch;
    protected final T exactMatch;
    protected String delimiter = "/";
    protected boolean caseSensitive = false;
    protected String wildcard = "*";
    protected int wildcardLength = 1;
    protected String oneLevelWildcard = "-*-";
    protected int oneLevelWildcardLength = 3;
    protected boolean wildcardEmbedded = true;
    protected boolean oneLevelWildcardEmbedded = false;
    protected Debug debug;
    private static final String PROTO_DELIMITER = "://";
    private static final int PROTO_DELIMITER_SIZE = "://".length();
    private static final String CURRENT_PATH = ".";
    private static final String PARENT_PATH = "..";

    protected BasePrefixResourceName(Debug debug, T exactMatch, T noMatch, T subResourceMatch, T superResourceMatch, T wildcardMatch) {
        this.debug = debug;
        this.exactMatch = exactMatch;
        this.noMatch = noMatch;
        this.subResourceMatch = subResourceMatch;
        this.superResourceMatch = superResourceMatch;
        this.wildcardMatch = wildcardMatch;
    }

    @Override
    public void initialize(Map configParams) {
    }

    @Override
    public Set<String> getServiceTypeNames() {
        return null;
    }

    @Override
    public T compare(String requestResource, String targetResource, boolean wildcardCompare) {
        if (requestResource == null && targetResource == null) {
            return this.exactMatch;
        }
        if (requestResource == null || targetResource == null) {
            return this.noMatch;
        }
        if (!this.caseSensitive) {
            requestResource = requestResource.toLowerCase();
            targetResource = targetResource.toLowerCase();
        }
        requestResource = this.normalizeRequestResource(requestResource);
        targetResource = this.normalizeTargetResource(targetResource);
        if (this.oneLevelWildcardEmbedded && targetResource.indexOf(this.wildcard) == -1 && targetResource.indexOf(this.oneLevelWildcard) != -1 && wildcardCompare) {
            this.debug.message("PrefixResourceName:compare():invoking one level compare");
            return this.oneLevelWildcardCompare(requestResource, targetResource, wildcardCompare);
        }
        if ((this.wildcardEmbedded || !this.wildcardEmbedded && !this.oneLevelWildcardEmbedded) && targetResource.indexOf(this.oneLevelWildcard) != -1 && wildcardCompare) {
            this.debug.message("PrefixResourceName:compare():invoking one level compare");
            return this.oneLevelWildcardCompare(requestResource, targetResource, wildcardCompare);
        }
        int reqBegin = 0;
        int reqEnd = 0;
        int tarBegin = 0;
        int tarEnd = 0;
        int reqLen = 0;
        int tarLen = 0;
        String subString = null;
        reqLen = requestResource.length();
        tarLen = targetResource.length();
        tarEnd = targetResource.indexOf(this.wildcard, tarBegin);
        if (!wildcardCompare || tarEnd == -1) {
            if (requestResource.equals(targetResource)) {
                return this.exactMatch;
            }
            if (targetResource.startsWith(requestResource.endsWith(this.delimiter) ? requestResource : requestResource + this.delimiter)) {
                return this.subResourceMatch;
            }
            if (requestResource.startsWith(targetResource.endsWith(this.delimiter) ? targetResource : targetResource + this.delimiter)) {
                return this.superResourceMatch;
            }
            return this.noMatch;
        }
        subString = targetResource.substring(tarBegin, tarEnd);
        if (tarEnd > tarBegin && !requestResource.startsWith(subString)) {
            if (subString.startsWith(requestResource.endsWith(this.delimiter) ? requestResource : requestResource + this.delimiter)) {
                return this.subResourceMatch;
            }
            return this.noMatch;
        }
        reqBegin = tarEnd;
        if (tarEnd >= tarLen - 1) {
            return this.wildcardMatch;
        }
        tarBegin = tarEnd + 1;
        while ((tarEnd = targetResource.indexOf(this.wildcard, tarBegin)) != -1) {
            subString = targetResource.substring(tarBegin, tarEnd);
            if (tarEnd > tarBegin && (reqBegin = requestResource.indexOf(subString, reqBegin)) == -1) {
                return this.subResourceMatch;
            }
            if (tarEnd >= tarLen - 1) {
                return this.wildcardMatch;
            }
            reqBegin += tarEnd - tarBegin;
            tarBegin = tarEnd + 1;
        }
        subString = targetResource.substring(tarBegin, tarLen);
        reqEnd = requestResource.lastIndexOf(subString, reqLen - 1);
        if (reqEnd == -1) {
            return this.subResourceMatch;
        }
        if (reqBegin > reqEnd) {
            return this.subResourceMatch;
        }
        reqBegin = reqEnd;
        if (reqLen - reqBegin == tarLen - tarBegin) {
            return this.wildcardMatch;
        }
        if ((subString = requestResource.substring(reqBegin += tarLen - tarBegin, reqBegin + 1)).equals(this.delimiter)) {
            return this.superResourceMatch;
        }
        return this.subResourceMatch;
    }

    protected String normalizeTargetResource(String targetResource) {
        return targetResource;
    }

    protected String normalizeRequestResource(String requestResource) {
        return requestResource;
    }

    public T oneLevelWildcardCompare(String requestResource, String targetResource, boolean wildcardCompare) {
        StringTokenizer st1 = new StringTokenizer(requestResource, this.delimiter);
        StringTokenizer st2 = new StringTokenizer(targetResource, this.delimiter);
        String[] requestTokens = new String[st1.countTokens()];
        String[] targetTokens = new String[st2.countTokens()];
        int i = 0;
        int j = 0;
        while (st1.hasMoreTokens()) {
            requestTokens[i++] = st1.nextToken();
        }
        while (st2.hasMoreTokens()) {
            targetTokens[j++] = st2.nextToken();
        }
        boolean wildcardMatch = false;
        j = 0;
        i = 0;
        while (i < requestTokens.length) {
            String requestToken = requestTokens[i++];
            if (j < targetTokens.length) {
                String targetToken;
                Object matchTokensResult = null;
                if ((matchTokensResult = (Object)this.matchTokens(targetToken = this.aggregateWildcard(targetTokens[j++]), requestToken)).equals(this.noMatch)) {
                    return (T)matchTokensResult;
                }
                if (!matchTokensResult.equals(this.wildcardMatch)) continue;
                wildcardMatch = true;
                continue;
            }
            if (i <= requestTokens.length) {
                return this.superResourceMatch;
            }
            return this.noMatch;
        }
        if (j < targetTokens.length) {
            if (j == targetTokens.length - 1 && this.aggregateWildcard(targetTokens[j]).equals(this.oneLevelWildcard)) {
                return this.wildcardMatch;
            }
            return this.subResourceMatch;
        }
        if (wildcardMatch) {
            return this.wildcardMatch;
        }
        return this.exactMatch;
    }

    private String aggregateWildcard(String targetToken) {
        int len = 0;
        if (targetToken == null || (len = targetToken.length()) == 0) {
            return targetToken;
        }
        char[] oldchars = targetToken.toCharArray();
        char[] newchars = new char[len];
        int i = 0;
        int j = 0;
        int k = 0;
        boolean foundWildcard = false;
        while (i < len) {
            if (targetToken.startsWith(this.oneLevelWildcard, i)) {
                if (!foundWildcard) {
                    k = i;
                    while (i < k + this.oneLevelWildcardLength) {
                        newchars[j++] = oldchars[i++];
                    }
                    foundWildcard = true;
                    continue;
                }
                i += this.oneLevelWildcardLength;
                continue;
            }
            foundWildcard = false;
            newchars[j++] = oldchars[i++];
        }
        return String.valueOf(newchars, 0, j);
    }

    private T matchTokens(String targetToken, String requestToken) {
        int wildcardIndex = 0;
        if (targetToken == null && requestToken == null) {
            return this.exactMatch;
        }
        if (targetToken == null || requestToken == null) {
            return this.noMatch;
        }
        int beginTargetIndex = 0;
        int beginRequestIndex = 0;
        String substr = null;
        int targetTokenLength = targetToken.length();
        int requestTokenLength = requestToken.length();
        if (targetToken.indexOf(this.oneLevelWildcard, beginTargetIndex) != -1) {
            while ((wildcardIndex = targetToken.indexOf(this.oneLevelWildcard, beginTargetIndex)) != -1) {
                if (wildcardIndex > beginTargetIndex) {
                    substr = targetToken.substring(beginTargetIndex, wildcardIndex);
                    beginRequestIndex = requestToken.indexOf(substr, beginRequestIndex);
                    if (beginRequestIndex == -1) {
                        return this.noMatch;
                    }
                    beginTargetIndex = beginTargetIndex + substr.length() + this.oneLevelWildcardLength;
                    beginRequestIndex += substr.length();
                    continue;
                }
                if (wildcardIndex != beginTargetIndex) continue;
                if (targetTokenLength == this.oneLevelWildcardLength) {
                    return this.wildcardMatch;
                }
                beginTargetIndex += this.oneLevelWildcardLength;
            }
            if (beginTargetIndex >= targetTokenLength) {
                return this.wildcardMatch;
            }
            String targetStr = targetToken.substring(beginTargetIndex, targetTokenLength);
            String remRequest = requestToken.substring(beginRequestIndex, requestTokenLength);
            int remRequestIndex = -1;
            remRequestIndex = remRequest.lastIndexOf(targetStr, remRequest.length() - 1);
            if (remRequestIndex == -1) {
                return this.noMatch;
            }
            if ((beginRequestIndex += remRequestIndex) + targetStr.length() >= requestTokenLength) {
                return this.wildcardMatch;
            }
            return this.noMatch;
        }
        if (targetToken.equals(requestToken)) {
            return this.exactMatch;
        }
        return this.noMatch;
    }

    @Override
    public String append(String superResource, String subResource) {
        if (superResource.endsWith(this.delimiter) && subResource.startsWith(this.delimiter)) {
            superResource = superResource.substring(0, superResource.length() - 1);
        }
        if (!superResource.endsWith(this.delimiter) && !subResource.startsWith(this.delimiter)) {
            subResource = this.delimiter + subResource;
        }
        return superResource + subResource;
    }

    @Override
    public String getSubResource(String resource, String superResource) {
        String subResource = null;
        if (!superResource.endsWith(this.delimiter)) {
            superResource = superResource + this.delimiter;
        }
        if (resource.startsWith(superResource)) {
            subResource = resource.substring(superResource.length());
        }
        return subResource;
    }

    @Override
    public String[] split(String res) {
        String protocol = "";
        int doubleD = res.indexOf(this.delimiter + this.delimiter);
        if (doubleD != -1) {
            protocol = res.substring(0, doubleD + 2);
            res = res.substring(doubleD + 2);
        }
        StringTokenizer st = new StringTokenizer(res, this.delimiter);
        int n = st.countTokens();
        String[] retVal = new String[n];
        for (int i = 0; i < n; ++i) {
            retVal[i] = st.nextToken();
        }
        retVal[0] = protocol + retVal[0];
        if (res.startsWith(this.delimiter)) {
            retVal[0] = retVal[0] + this.delimiter;
        }
        if (res.endsWith(this.delimiter)) {
            retVal[n - 1] = retVal[n - 1] + this.delimiter;
        }
        return retVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String canonicalize(String res) throws E {
        int queryIdx;
        boolean errorCondition = false;
        int startOneLevelIndex = res.indexOf(this.oneLevelWildcard);
        int endOneLevelIndex = startOneLevelIndex != -1 ? startOneLevelIndex + this.oneLevelWildcardLength - 1 : -1;
        int startWildcardIndex = res.indexOf(this.wildcard);
        int endWildcardIndex = startWildcardIndex != -1 ? startWildcardIndex + this.wildcardLength - 1 : -1;
        int resLength = res.length();
        boolean oneLevelFound = false;
        if (this.wildcardEmbedded) {
            while (startWildcardIndex != -1 && startWildcardIndex + this.wildcardLength <= resLength) {
                block17: {
                    if (startOneLevelIndex != -1) {
                        if (startWildcardIndex >= startOneLevelIndex && endOneLevelIndex >= endWildcardIndex) {
                            oneLevelFound = true;
                            break block17;
                        } else {
                            errorCondition = true;
                            break;
                        }
                    }
                    if (oneLevelFound) {
                        errorCondition = true;
                        break;
                    }
                }
                startOneLevelIndex = res.indexOf(this.oneLevelWildcard, endOneLevelIndex + 1);
                endOneLevelIndex = startOneLevelIndex != -1 ? startOneLevelIndex + this.oneLevelWildcardLength - 1 : -1;
                startWildcardIndex = res.indexOf(this.wildcard, endWildcardIndex + 1);
                endWildcardIndex = startWildcardIndex != -1 ? startWildcardIndex + this.wildcardLength - 1 : -1;
            }
        }
        boolean wildcardFound = false;
        if (this.oneLevelWildcardEmbedded) {
            while (startOneLevelIndex != -1 && startOneLevelIndex + this.oneLevelWildcardLength <= resLength) {
                block18: {
                    if (startWildcardIndex != -1) {
                        if (startOneLevelIndex >= startWildcardIndex && endWildcardIndex >= endOneLevelIndex) {
                            wildcardFound = true;
                            break block18;
                        } else {
                            errorCondition = true;
                            break;
                        }
                    }
                    if (wildcardFound) {
                        errorCondition = true;
                        break;
                    }
                }
                startOneLevelIndex = res.indexOf(this.oneLevelWildcard, endOneLevelIndex + 1);
                endOneLevelIndex = startOneLevelIndex != -1 ? startOneLevelIndex + this.oneLevelWildcardLength - 1 : -1;
                startWildcardIndex = res.indexOf(this.wildcard, endWildcardIndex + 1);
                endWildcardIndex = startWildcardIndex != -1 ? startWildcardIndex + this.wildcardLength - 1 : -1;
            }
        }
        if (!this.oneLevelWildcardEmbedded && !this.wildcardEmbedded && res.indexOf(this.oneLevelWildcard) != -1 && res.indexOf(this.wildcard) != -1) {
            errorCondition = true;
        }
        if (errorCondition) {
            throw this.constructResourceInvalidException(null);
        }
        int idx = res.indexOf(PROTO_DELIMITER);
        if (idx < 0) {
            return this.normalizePath(res);
        }
        String protoString = res.substring(0, idx + PROTO_DELIMITER_SIZE);
        String remainingResource = res.substring(idx + PROTO_DELIMITER_SIZE);
        String hostString = "";
        String queryString = "";
        int slashIdx = remainingResource.indexOf(47);
        if (slashIdx != -1) {
            hostString = remainingResource.substring(0, slashIdx);
            remainingResource = remainingResource.substring(slashIdx);
        }
        if ((queryIdx = remainingResource.indexOf(63)) != -1) {
            queryString = remainingResource.substring(queryIdx);
            remainingResource = remainingResource.substring(0, queryIdx);
        }
        return protoString + hostString + this.normalizePath(remainingResource) + queryString;
    }

    private String normalizePath(String resource) {
        if (resource == null || resource.isEmpty()) {
            return "";
        }
        int len = resource.length();
        char[] oldchars = resource.toCharArray();
        ArrayDeque<String> segments = new ArrayDeque<String>();
        char delimiterChar = this.delimiter.charAt(0);
        int j = 0;
        for (int i = 0; i < len; ++i) {
            if (oldchars[i] != delimiterChar) continue;
            if (i != j) {
                String segment = new String(oldchars, j, i - j);
                if (segment.equals(PARENT_PATH)) {
                    if (segments.size() > 0) {
                        segments.removeLast();
                    }
                } else if (!segment.equals(CURRENT_PATH)) {
                    segments.add(segment);
                }
                j = i + 1;
                continue;
            }
            ++j;
        }
        if (oldchars[len - 1] != delimiterChar) {
            segments.add(new String(oldchars, j, len - j));
        }
        StringBuilder result = new StringBuilder(resource.length());
        for (String segment : segments) {
            result.append(delimiterChar).append(segment);
        }
        if (!resource.startsWith(this.delimiter)) {
            result.deleteCharAt(0);
        }
        if (resource.endsWith(this.delimiter)) {
            result.append(delimiterChar);
        }
        return result.toString();
    }

    protected abstract E constructResourceInvalidException(Object[] var1);
}

