/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.monitoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.forgerock.openam.shared.monitoring.TimingEntry;

public abstract class AbstractTimingStore {
    protected final int maxEntries;
    protected final List<TimingEntry> durationStore = Collections.synchronizedList(new ArrayList<TimingEntry>(){

        @Override
        public boolean add(TimingEntry entry) {
            while (this.size() >= AbstractTimingStore.this.maxEntries) {
                this.remove(0);
            }
            return super.add(entry);
        }
    });

    public AbstractTimingStore(int maxEntries) {
        this.maxEntries = maxEntries < 100 ? 100 : maxEntries;
    }

    public long getDurationAverage() {
        if (this.durationStore.size() == 0) {
            return 0L;
        }
        long current = 0L;
        for (TimingEntry te : this.durationStore) {
            current += te.getDuration();
        }
        return current / (long)this.durationStore.size();
    }

    public String getSlowestEvaluation() {
        TimingEntry te = this.getSlowest();
        if (te == null) {
            return "";
        }
        return te.toString();
    }

    public long getSlowestEvaluationDuration() {
        TimingEntry te = this.getSlowest();
        if (te == null) {
            return 0L;
        }
        return te.getDuration();
    }

    private TimingEntry getSlowest() {
        if (this.durationStore == null || this.durationStore.size() == 0) {
            return null;
        }
        TimingEntry current = this.durationStore.get(0);
        for (TimingEntry te : this.durationStore) {
            if (current.getDuration() >= te.getDuration()) continue;
            current = te;
        }
        return current;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }
}

