/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.shared.debug.Debug;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.forgerock.guice.core.GuiceModule;
import org.forgerock.http.Client;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.openam.audit.context.AMExecutorServiceFactory;
import org.forgerock.openam.audit.context.AuditRequestContextPropagatingExecutorServiceFactory;
import org.forgerock.openam.shared.concurrency.ThreadMonitor;
import org.forgerock.openam.shared.guice.CloseableHttpClientHandlerProvider;
import org.forgerock.openam.shared.guice.CloseableHttpClientProvider;
import org.forgerock.openam.shared.security.crypto.KeyPairProviderFactory;
import org.forgerock.openam.shared.security.crypto.KeyPairProviderFactoryImpl;

@GuiceModule
public class SharedGuiceModule
extends AbstractModule {
    public static final String DEBUG_THREAD_MANAGER = "amThreadManager";

    protected void configure() {
        this.bind(Debug.class).annotatedWith((Annotation)Names.named((String)DEBUG_THREAD_MANAGER)).toInstance((Object)Debug.getInstance(DEBUG_THREAD_MANAGER));
        this.bind(org.forgerock.util.thread.listener.ShutdownManager.class).toInstance((Object)ShutdownManager.getInstance());
        this.bind(KeyPairProviderFactory.class).to(KeyPairProviderFactoryImpl.class);
        this.bind(HttpClientHandler.class).toProvider(CloseableHttpClientHandlerProvider.class).in(Scopes.SINGLETON);
        this.bind(Client.class).toProvider(CloseableHttpClientProvider.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Inject
    AMExecutorServiceFactory provideAMExecutorServiceFactory(org.forgerock.util.thread.listener.ShutdownManager manager) {
        return new AuditRequestContextPropagatingExecutorServiceFactory(manager);
    }

    @Provides
    @Inject
    @Singleton
    ThreadMonitor provideThreadMonitor(AMExecutorServiceFactory factory, org.forgerock.util.thread.listener.ShutdownManager wrapper, @Named(value="amThreadManager") Debug debug) {
        return new ThreadMonitor(factory.createCachedThreadPool(DEBUG_THREAD_MANAGER), wrapper, debug);
    }
}

