/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.guice;

import com.google.inject.Provider;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import javax.inject.Inject;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.util.Options;
import org.forgerock.util.thread.listener.ShutdownManager;

public class CloseableHttpClientHandlerProvider
implements Provider<HttpClientHandler> {
    public static final Debug DEBUG = Debug.getInstance("amUtil");
    private ShutdownManager shutdownManager;

    @Inject
    public CloseableHttpClientHandlerProvider(ShutdownManager shutdownManager) {
        this.shutdownManager = shutdownManager;
    }

    public HttpClientHandler get() {
        try {
            Options options = Options.defaultOptions();
            options.set(HttpClientHandler.OPTION_PROXY_SYSTEM, (Object)SystemPropertiesManager.getAsBoolean("org.forgerock.openam.httpclienthandler.system.proxy.enabled", false));
            DEBUG.message("CloseableHttpClientHandlerProvider.get: System proxy enabled for HttpClientHandler: {}", options.get(HttpClientHandler.OPTION_PROXY_SYSTEM));
            HttpClientHandler httpClientHandler = new HttpClientHandler(options);
            this.shutdownManager.addShutdownListener(() -> {
                try {
                    httpClientHandler.close();
                }
                catch (IOException e) {
                    DEBUG.message("Unable to close the HttpClientHandler", e);
                }
            });
            return httpClientHandler;
        }
        catch (HttpApplicationException e) {
            DEBUG.error("Unable to create a new HttpClientHandler", e);
            return null;
        }
    }
}

