/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.concurrency;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockFactory<K> {
    private final Map<Key<K>, Reference<Lock>> lockCache = new WeakHashMap<Key<K>, Reference<Lock>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock acquireLock(K key) {
        KeyReferenceLock<K> lock;
        if (key == null) {
            throw new NullPointerException("Key must not be null");
        }
        Key<K> internalKey = new Key<K>(key);
        Map<Key<K>, Reference<Lock>> map = this.lockCache;
        synchronized (map) {
            Reference<Lock> holder = this.lockCache.get(internalKey);
            if (holder == null || (lock = holder.get()) == null) {
                lock = new KeyReferenceLock<K>(internalKey);
                this.lockCache.put(internalKey, new WeakReference<KeyReferenceLock<K>>(lock));
            }
        }
        return lock;
    }

    private static final class KeyReferenceLock<K>
    extends ReentrantLock {
        private final Key<K> keyReference;

        public KeyReferenceLock(Key<K> keyReference) {
            this.keyReference = keyReference;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("KeyReferenceLock[keyReference=");
            builder.append(this.keyReference);
            builder.append(',');
            builder.append(super.toString());
            builder.append(']');
            return builder.toString();
        }
    }

    private static final class Key<K> {
        private final K value;

        public Key(K value) {
            this.value = value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.value == null ? key.value == null : this.value.equals(key.value);
        }

        public String toString() {
            return "Key[value=" + this.value + ']';
        }
    }
}

