/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.xml;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.ValidationErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.forgerock.openam.utils.DocumentBuilderProvider;
import org.forgerock.openam.utils.Providers;
import org.forgerock.openam.utils.SAXParserProvider;
import org.forgerock.openam.utils.TransformerFactoryProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private static boolean validating = false;
    private static String ATTR_BASE64_ENCODED = "com_sun_identity_opensso_base64_encoded";
    private static int ATTR_BASE64_ENCODED_LENGTH = ATTR_BASE64_ENCODED.length();
    private static final String INVALID_XML_CHARACTERS = "[\u0000-\b\u000b-\u001f\ufffe\uffff]";
    private static Pattern invalidXMLChars = Pattern.compile("[\u0000-\b\u000b-\u001f\ufffe\uffff]");
    private static final int DOCBUILDER_CACHE_SIZE;
    private static final int SAXPARSER_CACHE_SIZE;
    private static final int TRANSFORMER_FACTORY_CACHE_SIZE;
    private static final DocumentBuilderProvider DOCUMENT_BUILDER_PROVIDER;
    private static final SAXParserProvider SAX_PARSER_PROVIDER;
    private static final TransformerFactoryProvider TRANSFORMER_FACTORY_PROVIDER;
    private static String ATTR_VALUE_PAIR_NODE;
    private static String VALUE_NODE;

    public String getATTR_VALUE_PAIR_NODE() {
        return ATTR_VALUE_PAIR_NODE;
    }

    public static boolean isValidating() {
        return validating;
    }

    public static Document toDOMDocument(String xmlString, Debug debug) {
        if (xmlString == null || xmlString.length() == 0) {
            return null;
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
            return XMLUtils.toDOMDocument(is, debug);
        }
        catch (UnsupportedEncodingException uee) {
            if (debug != null && debug.warningEnabled()) {
                debug.warning("Can't parse the XML document:\n" + xmlString, uee);
            }
            return null;
        }
    }

    public static Document toDOMDocument(InputStream is, Debug debug) {
        DocumentBuilder documentBuilder;
        block8: {
            documentBuilder = null;
            try {
                documentBuilder = XMLUtils.getSafeDocumentBuilder(validating);
            }
            catch (ParserConfigurationException pe) {
                if (debug == null) break block8;
                debug.error("XMLUtils.DocumentBuilder init failed", pe);
            }
        }
        try {
            if (documentBuilder == null) {
                if (debug != null) {
                    debug.error("XMLUtils.toDOM : null builder instance");
                }
                return null;
            }
            if (debug != null && debug.warningEnabled()) {
                documentBuilder.setErrorHandler(new ValidationErrorHandler(debug));
            }
            return documentBuilder.parse(is);
        }
        catch (Exception e) {
            if (debug != null && debug.warningEnabled()) {
                debug.warning("Can't parse the XML document", e);
            }
            return null;
        }
    }

    public static Set parseAttributesTag(Node n) {
        NodeList attributes = n.getChildNodes();
        int numAttributes = attributes.getLength();
        if (numAttributes == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int l = 0; l < numAttributes; ++l) {
            Node attr = attributes.item(l);
            if (attr.getNodeType() != 1 && !attr.getNodeName().equals("Attribute")) continue;
            set.add(((Element)attr).getAttribute("name"));
        }
        return set;
    }

    public static Map<String, Set<String>> parseAttributeValuePairTags(Node parentNode) {
        NodeList keyValueList = parentNode.getChildNodes();
        int keyValueSize = keyValueList.getLength();
        if (keyValueSize <= 0) {
            return EMPTY_MAP;
        }
        HashMap resultMap = null;
        for (int l = 0; l < keyValueSize; ++l) {
            Set oldValues;
            NodeList keyValueEntryList;
            int keyValueEntrySize;
            Node keyValueNode = keyValueList.item(l);
            if (keyValueNode.getNodeType() != 1 || !keyValueNode.getNodeName().equals("AttributeValuePair") || (keyValueEntrySize = (keyValueEntryList = keyValueNode.getChildNodes()).getLength()) < 2) continue;
            Node keyNode = null;
            for (int i = 0; !(i >= keyValueEntrySize || (keyNode = keyValueEntryList.item(i)).getNodeType() == 1 && keyNode.getNodeName().equals("Attribute")); ++i) {
            }
            String key = ((Element)keyNode).getAttribute("name");
            HashSet<String> values = null;
            for (int m = 0; m < keyValueEntrySize; ++m) {
                String value;
                Node firstChild;
                Node valueNode = keyValueEntryList.item(m);
                if (valueNode.getNodeType() != 1 || !valueNode.getNodeName().equals("Value")) continue;
                if (values == null) {
                    values = new HashSet<String>();
                }
                if ((firstChild = valueNode.getFirstChild()) == null || (value = firstChild.getNodeValue()) == null) continue;
                values.add(value.trim());
            }
            if (values == null) continue;
            if (resultMap == null) {
                resultMap = new HashMap();
            }
            if ((oldValues = (Set)resultMap.get(key)) != null) {
                values.addAll(oldValues);
            }
            resultMap.put(key, values);
        }
        return resultMap == null ? EMPTY_MAP : resultMap;
    }

    public static Document newDocument() throws ParserConfigurationException {
        return XMLUtils.getSafeDocumentBuilder(validating).newDocument();
    }

    public static Document getXMLDocument(InputStream in) throws Exception {
        try {
            DocumentBuilder builder = XMLUtils.getSafeDocumentBuilder(validating);
            Document doc = builder.parse(in);
            return doc;
        }
        catch (SAXParseException pe) {
            String msg = "\n" + pe.getMessage() + "\n";
            Object[] params = new Object[]{new Integer(pe.getLineNumber())};
            throw new Exception(msg + "XMLUtils.parser_error" + params);
        }
        catch (SAXException sax) {
            Object[] params = new Object[]{sax.getMessage()};
            throw new Exception("XMLUtils.exception_message" + params);
        }
        catch (ParserConfigurationException pc) {
            Object[] params = new Object[]{pc.getMessage()};
            throw new Exception("XMLUtils.invalid_xml_document" + params);
        }
        catch (IOException ioe) {
            Object[] params = new Object[]{ioe.getMessage()};
            throw new Exception("XMLUtils.invalid_input_stream" + params);
        }
    }

    public static Node getRootNode(Document doc, String nodeName) {
        NodeList nodes = doc.getElementsByTagName(nodeName);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return nodes.item(0);
    }

    public static Node getChildNode(Node parentNode, String childName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equalsIgnoreCase(childName)) continue;
            return node;
        }
        return null;
    }

    public static boolean hasElementChild(Node node) {
        NodeList nl = node.getChildNodes();
        Node child = null;
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static Node getNamedChildNode(Node parentNode, String childNodeName, String attrName, String attrValue) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!childNodeName.equalsIgnoreCase(node.getNodeName()) || !XMLUtils.getNodeAttributeValue(node, attrName).equalsIgnoreCase(attrValue)) continue;
            return node;
        }
        return null;
    }

    public static Set getChildNodes(Node parentNode, String childName) {
        LinkedHashSet<Node> retVal = new LinkedHashSet<Node>();
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equalsIgnoreCase(childName)) continue;
            retVal.add(node);
        }
        return retVal;
    }

    public static String getElementValue(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(1000);
        NodeList nl = element.getChildNodes();
        Node child = null;
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            child = nl.item(i);
            if (child.getNodeType() != 3) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static String getChildrenValue(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(1000);
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            sb.append(XMLUtils.print(nl.item(i)));
        }
        return sb.toString().trim();
    }

    public static String getElementString(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(1000);
        NodeList nl = element.getChildNodes();
        Node child = null;
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            child = nl.item(i);
            if (child.getNodeType() != 3) {
                return null;
            }
            sb.append(child.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static String getNodeAttributeValue(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node value = attrs.getNamedItem(attrName);
        if (value == null) {
            return null;
        }
        return value.getNodeValue();
    }

    public static String getNodeAttributeValueNS(Node node, String namespaceURI, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node value = attrs.getNamedItemNS(namespaceURI, attrName);
        if (value == null) {
            return null;
        }
        return value.getNodeValue();
    }

    public static Set<String> getAttributeValuePair(Node node) {
        return XMLUtils.getAttributeValuePair(node, true);
    }

    public static Set<String> getAttributeValuePair(Node node, boolean unescape) {
        if (!node.getNodeName().equals(ATTR_VALUE_PAIR_NODE)) {
            return null;
        }
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!n.getNodeName().equalsIgnoreCase(VALUE_NODE)) continue;
            retVal.add(XMLUtils.getValueOfValueNode(n, unescape));
        }
        return retVal;
    }

    public static String getValueOfValueNode(Node n) {
        return XMLUtils.getValueOfValueNode(n, true);
    }

    public static String getValueOfValueNode(Node n, boolean unescape) {
        return XMLUtils.getValueOfValueNodeNoTrim(n, unescape).trim();
    }

    public static String getValueOfValueNodeNoTrim(Node n) {
        return XMLUtils.getValueOfValueNodeNoTrim(n, true);
    }

    public static String getValueOfValueNodeNoTrim(Node n, boolean unescape) {
        NodeList textNodes = n.getChildNodes();
        StringBuffer value = new StringBuffer("");
        for (int j = 0; j < textNodes.getLength(); ++j) {
            Node textNode = textNodes.item(j);
            String text = null;
            if (textNode.getNodeType() == 3) {
                text = textNode.getNodeValue();
            } else if (textNode.getNodeType() == 1) {
                text = XMLUtils.print(textNode);
            }
            if (text != null && unescape) {
                value.append(XMLUtils.unescapeSpecialCharacters(text));
                continue;
            }
            value.append(text);
        }
        return value.toString();
    }

    public static List getElementsByTagNameNS1(Element element, String nsName, String tagName) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (element != null) {
            NodeList nl = element.getChildNodes();
            int length = nl.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = nl.item(i);
                String childName = child.getLocalName();
                String childNS = child.getNamespaceURI();
                if (childName == null || !childName.equals(tagName) || childNS == null || !childNS.equals(nsName)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public static String printAttributeValue(Element node, String prefix) {
        if (node == null) {
            return null;
        }
        StringBuffer xml = new StringBuffer(100);
        xml.append('<');
        xml.append(prefix).append(node.getLocalName());
        NamedNodeMap attrs = node.getAttributes();
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attrs.item(i);
            xml.append(' ');
            xml.append(attr.getNodeName());
            xml.append("=\"");
            xml.append(attr.getNodeValue());
            xml.append('\"');
        }
        xml.append('>');
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                xml.append(XMLUtils.print(children.item(i)));
            }
        }
        xml.append("</");
        xml.append(prefix).append(node.getLocalName());
        xml.append('>');
        return xml.toString();
    }

    public static String print(Node node) {
        return XMLUtils.print(node, "UTF-8");
    }

    public static String print(Node node, String encoding) {
        if (node == null) {
            return null;
        }
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", encoding);
            DOMSource source = new DOMSource(node);
            ByteArrayOutputStream os = new ByteArrayOutputStream(2000);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            return os.toString(encoding);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String unescapeSpecialCharacters(String text) {
        text = text.replaceAll("&amp;", "&");
        text = text.replaceAll("&lt;", "<");
        text = text.replaceAll("&gt;", ">");
        text = text.replaceAll("&quot;", "\"");
        text = text.replaceAll("&apos;", "'");
        text = text.replaceAll("&#xA;", "\n");
        text = text.replaceAll("&#xD;", "\r");
        return text;
    }

    public static String escapeSpecialCharacters(String text) {
        if ((text = XMLUtils.removeInvalidXMLChars(text)) == null || text.isEmpty()) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length());
        block9: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block9;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block9;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block9;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block9;
                }
                case '\n': {
                    sb.append("&#xA;");
                    continue block9;
                }
                case '\r': {
                    sb.append("&#xD;");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static boolean invalidXMLCharExists(String st) {
        Matcher matcher = invalidXMLChars.matcher(st);
        return matcher.find();
    }

    public static String removeInvalidXMLChars(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.replaceAll(INVALID_XML_CHARACTERS, "");
    }

    public static Set encodeAttributeSet(Set set, Debug debug) {
        if (set == null) {
            return set;
        }
        HashSet<String> newSet = new HashSet<String>();
        for (Object obj : set) {
            String st = (String)obj;
            if (XMLUtils.invalidXMLCharExists(st)) {
                st = Base64.encode(st.getBytes());
                if (debug != null && debug.warningEnabled()) {
                    debug.warning("XMLUtils.encodeAttributeSet invalid XML characters get Base64 encoded to be : " + st);
                }
                st = ATTR_BASE64_ENCODED + st;
            }
            newSet.add(st);
        }
        return newSet;
    }

    public static Set decodeAttributeSet(Set set) {
        if (set == null) {
            return set;
        }
        HashSet<String> newSet = new HashSet<String>();
        for (Object obj : set) {
            String st = (String)obj;
            if (st.startsWith(ATTR_BASE64_ENCODED)) {
                st = new String(Base64.decode(st.substring(ATTR_BASE64_ENCODED_LENGTH)));
            }
            newSet.add(st);
        }
        return newSet;
    }

    public static String removeNullCharAtEnd(String st) {
        int index = st.length() - 1;
        char c = st.charAt(index);
        if (c == '\u0000') {
            return st.substring(0, index);
        }
        return st;
    }

    public static DocumentBuilder getSafeDocumentBuilder(boolean validating) throws ParserConfigurationException {
        return DOCUMENT_BUILDER_PROVIDER.getDocumentBuilder(validating);
    }

    public static SAXParser getSafeSAXParser(boolean validating) throws ParserConfigurationException, SAXException {
        return SAX_PARSER_PROVIDER.getSAXParser(validating);
    }

    public static TransformerFactory getTransformerFactory() {
        return TRANSFORMER_FACTORY_PROVIDER.getTransformerFactory();
    }

    public static SAXSource createSAXSource(InputSource source) throws JAXBException {
        try {
            SAXParser saxParser = XMLUtils.getSafeSAXParser(false);
            return new SAXSource(saxParser.getXMLReader(), source);
        }
        catch (Exception ex) {
            throw new JAXBException("Unable to create SAXSource", (Throwable)ex);
        }
    }

    static {
        try {
            String xmlVal = SystemPropertiesManager.get("com.iplanet.am.util.xml.validating", "off");
            String debugLevel = SystemPropertiesManager.get("com.iplanet.services.debug.level", "error");
            if (xmlVal.trim().equalsIgnoreCase("on") && (debugLevel.trim().equalsIgnoreCase("warning") || debugLevel.trim().equalsIgnoreCase("message"))) {
                validating = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DOCBUILDER_CACHE_SIZE = SystemPropertiesManager.getAsInt("org.forgerock.openam.utils.xml.documentbuilder.cache.size", 500);
        SAXPARSER_CACHE_SIZE = SystemPropertiesManager.getAsInt("org.forgerock.openam.utils.xml.saxparser.cache.size", DOCBUILDER_CACHE_SIZE);
        TRANSFORMER_FACTORY_CACHE_SIZE = SystemPropertiesManager.getAsInt("org.forgerock.openam.utils.xml.transformerfactory.cache.size", 500);
        DOCUMENT_BUILDER_PROVIDER = Providers.documentBuilderProvider(DOCBUILDER_CACHE_SIZE);
        SAX_PARSER_PROVIDER = Providers.saxParserProvider(SAXPARSER_CACHE_SIZE);
        TRANSFORMER_FACTORY_PROVIDER = Providers.transformerFactoryProvider(TRANSFORMER_FACTORY_CACHE_SIZE);
        ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
        VALUE_NODE = "Value";
    }
}

