/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.whitelist;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.whitelist.HttpURLResourceName;
import com.sun.identity.shared.whitelist.ResourceMatch;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;

public class URLPatternMatcher {
    private static final Debug DEBUG = Debug.getInstance("patternMatching");
    private HttpURLResourceName resourceName = new HttpURLResourceName();

    public URLPatternMatcher() {
        this.resourceName.initialize(new HashMap());
    }

    public boolean match(String requestedURL, Collection<String> patterns, boolean wildcard) throws MalformedURLException {
        boolean result = false;
        for (String pattern : patterns) {
            ResourceMatch res;
            String patternLower = pattern.toLowerCase();
            requestedURL = this.resourceName.canonicalize(requestedURL);
            if (pattern.startsWith("/")) {
                pattern = this.convertToURL(pattern, requestedURL);
            } else if (!patternLower.startsWith("http")) {
                pattern = this.convertToURL("/" + pattern, requestedURL);
            }
            pattern = this.resourceName.canonicalize(pattern);
            if (DEBUG.messageEnabled()) {
                DEBUG.message("URLPatternMatcher.match(" + requestedURL + "): matching by pattern: " + pattern);
            }
            if ((res = this.resourceName.compare(requestedURL, pattern, wildcard)) != ResourceMatch.WILDCARD_MATCH && res != ResourceMatch.EXACT_MATCH) continue;
            if (DEBUG.messageEnabled()) {
                DEBUG.message("URLPatternMatcher.match(" + requestedURL + "): matched by pattern: " + pattern + " result = " + res);
            }
            result = true;
            break;
        }
        return result;
    }

    private String convertToURL(String pattern, String requestedURL) {
        block2: {
            StringBuilder builder = new StringBuilder();
            try {
                URL url = new URL(requestedURL);
                builder.append(url.getProtocol()).append("://");
                builder.append(url.getHost()).append(":");
                builder.append(url.getPort());
                builder.append(pattern);
                pattern = builder.toString();
            }
            catch (MalformedURLException ex) {
                if (!DEBUG.warningEnabled()) break block2;
                DEBUG.warning("URLPatternMatcher.convertToURL()- pattern:" + pattern + " requestedURL:" + requestedURL + " Exception:", ex);
            }
        }
        return pattern;
    }
}

