/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.test.tools;

import com.sun.identity.shared.test.tools.Suite;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ReportGenerator {
    private String dataDir;
    private String templateDir;
    private String outputDir;
    private List<Suite> suitesPassed = new ArrayList<Suite>();
    private List<Suite> suitesFailed = new ArrayList<Suite>();

    public ReportGenerator(String dataDir, String templateDir, String outputDir) {
        this.dataDir = dataDir;
        this.templateDir = templateDir;
        this.outputDir = outputDir;
    }

    public void createHTMLReports() throws ParserConfigurationException, SAXException, IOException {
        Set<File> directories = this.getDirectories();
        for (File f : directories) {
            Suite suite = new Suite(f);
            if (suite.passed()) {
                this.suitesPassed.add(suite);
                continue;
            }
            this.suitesFailed.add(suite);
        }
        this.genMainPage();
    }

    private void genMainPage() throws IOException {
        String templateIndex = ReportGenerator.getFileContent(this.templateDir + "/index.html");
        StringBuffer buff = new StringBuffer();
        for (Suite s : this.suitesFailed) {
            buff.append(s.toHTML());
            s.createHTMLReports(this.templateDir, this.outputDir);
        }
        for (Suite s : this.suitesPassed) {
            buff.append(s.toHTML());
            s.createHTMLReports(this.templateDir, this.outputDir);
        }
        ReportGenerator.writeToFile(templateIndex.replaceAll("<!-- entry -->", buff.toString()), this.outputDir + "/index.html");
    }

    private Set<File> getDirectories() {
        TreeSet<File> directories = new TreeSet<File>();
        File oDir = new File(this.dataDir);
        File[] files = oDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.getName().startsWith(".") || !f.isDirectory()) continue;
            directories.add(f);
        }
        return directories;
    }

    public static void writeToFile(String content, String fileName) throws IOException {
        try (FileWriter fw = null;){
            fw = new FileWriter(fileName);
            fw.write(content, 0, content.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String fileName) throws IOException {
        StringBuffer buff = new StringBuffer();
        try (BufferedReader br = null;){
            br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            while (line != null) {
                buff.append(line).append("\n");
                line = br.readLine();
            }
        }
        return buff.toString();
    }

    public static void main(String[] args) {
        ReportGenerator gen = new ReportGenerator(args[0], args[1], args[2]);
        try {
            gen.createHTMLReports();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

