/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.jaxrpc;

import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.jaxrpc.JAXRPCHelper;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SOAPClient {
    static final Debug debug = Debug.getInstance("amJAXRPC");
    String serviceName;
    String[] urls;
    static final String ENVELOPE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns0=\"http://isp.com/types\" xmlns:ns1=\"http://java.sun.com/jax-rpc-ri/internal\" env:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">";
    static final String HEADSTART = "<env:Header>";
    static final String HEADEND = "</env:Header>";
    static final String ENV_BODY = "<env:Body>";
    static final String SUFFIX = "</env:Body></env:Envelope>\n";
    static final String BODY = "body";
    static final String RESULT = "result";
    static final String TYPE = "xsi:type";
    static final String STRING = "xsd:string";
    static final String INTEGER = "xsd:int";
    static final String BOOLEAN = "xsd:boolean";
    static final String SET = "ns1:hashSet";
    static final String TREESET = "ns1:treeSet";
    static final String MAP = "ns1:hashMap";
    static final String LIST = "ns1:linkedList";
    static final String MAPENTRY = "ns1:mapEntry";
    static final String ITEM = "item";
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String FAULT_STRING = "faultstring";
    static final String MESSAGE = "message";
    static final String ERROR_CODE = "errorCode";
    static final String EXCEPTION_CODE = "exceptionCode";
    static final String LDAP_ERROR_CODE = "LDAPErrorCode";
    static final String ERROR_STRING = "errorString";
    static final String RMIREMOTEEXCEPTION = "java.rmi.RemoteException";
    static final String SMSEXCEPTION = "com.sun.identity.sm.SMSException";
    static final String RESOURCE_BUNDLE_NAME = "resourceBundleName";
    static final String MESSAGE_ARGS = "messageArgs";
    static final String HREF = "href";
    static final String ARRAY_OF_ANY_TYPE = "ArrayOfanyType";
    static final String ARRAY_OF_STRING_TYPE = "ArrayOfString";
    static final String ID = "id";
    static final String DECODE_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns0=\"http://isp.com/types\" xmlns:ns1=\"http://java.sun.com/jax-rpc-ri/internal\" env:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><env:Body><ans1:readResponse xmlns:ans1=\"http://isp.com/wsdl\">";
    static final String DECODE_FOOTER = "</ans1:readResponse></env:Body></env:Envelope>";

    public SOAPClient() throws IOException {
    }

    public SOAPClient(String serviceName) {
        this.serviceName = serviceName;
    }

    public SOAPClient(String[] urls) {
        this.urls = urls;
    }

    public InputStream call(String message, String lbcookie, String cookies) throws Exception {
        if (lbcookie != null) {
            cookies = cookies == null || cookies.length() == 0 ? lbcookie : cookies + ";" + lbcookie;
        }
        return this.call(message, cookies).getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOAPResponseObject call(String message, String cookies) throws Exception {
        Object data;
        if (debug.messageEnabled()) {
            debug.message("SOAP Client: Message being sent:" + message);
        }
        String url = null;
        InputStream in_buf = null;
        boolean done = false;
        boolean isException = false;
        int urlIndex = 0;
        while (!done) {
            String userInfo;
            if (url == null) {
                if (this.urls != null) {
                    if (urlIndex >= this.urls.length) {
                        if (debug.warningEnabled()) {
                            debug.warning("SOAPClient: No vaild server found");
                        }
                        throw new RemoteException("no-server-found");
                    }
                    url = this.urls[urlIndex++];
                } else {
                    boolean validServerFound = false;
                    try {
                        url = JAXRPCHelper.getValidURL(this.serviceName);
                        if (url != null) {
                            validServerFound = true;
                            this.setURL(url);
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (!validServerFound) {
                        if (++urlIndex > 3) {
                            debug.error("SOAPClient::call() no valid servers");
                            throw new RemoteException("no-server-found");
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                }
            }
            URL endpoint = new URL(url);
            HttpURLConnection connection = HttpURLConnectionManager.getConnection(endpoint);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            connection.setRequestProperty("SOAPAction", "\"\"");
            if (cookies != null) {
                connection.setRequestProperty("Cookie", cookies);
            }
            if ((userInfo = endpoint.getUserInfo()) != null) {
                connection.setRequestProperty("Authorization", "Basic " + Base64.encode(userInfo.getBytes("UTF-8")));
            }
            data = message.getBytes("UTF-8");
            int requestLength = ((Object)data).length;
            connection.setRequestProperty("Content-Length", Integer.toString(requestLength));
            OutputStream out = null;
            try {
                out = connection.getOutputStream();
            }
            catch (ConnectException ce) {
                if (debug.warningEnabled()) {
                    debug.warning("SOAP Client: Connection Exception: " + url, ce);
                }
                JAXRPCHelper.serverFailed(url);
                url = null;
                continue;
            }
            out.write((byte[])data);
            out.flush();
            try {
                in_buf = connection.getInputStream();
            }
            catch (IOException ioe) {
                if (debug.messageEnabled()) {
                    debug.message("SOAP Client: READ Exception", ioe);
                }
                in_buf = connection.getErrorStream();
                isException = true;
            }
            finally {
                done = true;
            }
        }
        if (debug.messageEnabled()) {
            String line;
            StringBuffer inbuf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in_buf, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                inbuf.append(line).append("\n");
            }
            data = new String(inbuf);
            debug.message("SOAP Client: Input: " + message + "\nOutput: " + (String)data);
            in_buf = new ByteArrayInputStream(((String)data).getBytes("UTF-8"));
        }
        return new SOAPResponseObject(in_buf, isException);
    }

    public Object send(String functionName, Object[] params, String lbcookie, String cookies) throws Exception {
        return this.send(this.encodeMessage(functionName, params), lbcookie, cookies);
    }

    public Object send(String functionName, Object param, String lbcookie, String cookies) throws Exception {
        return this.send(this.encodeMessage(functionName, param), lbcookie, cookies);
    }

    public Object send(String message, String lbcookie, String cookies) throws Exception {
        if (lbcookie != null) {
            cookies = cookies == null || cookies.length() == 0 ? lbcookie : cookies + ";" + lbcookie;
        }
        return this.send(message, cookies);
    }

    private Object send(String message, String cookies) throws Exception {
        SOAPContentHandler handler;
        block5: {
            SOAPResponseObject response = this.call(message, cookies);
            InputStream in_buf = response.getResponse();
            handler = new SOAPContentHandler(response.isException());
            try {
                SAXParser saxParser = debug.warningEnabled() ? XMLUtils.getSafeSAXParser(true) : XMLUtils.getSafeSAXParser(false);
                XMLReader parser = saxParser.getXMLReader();
                parser.setContentHandler(handler);
                parser.setErrorHandler(new SOAPErrorHandler());
                parser.parse(new InputSource(in_buf));
            }
            catch (ParserConfigurationException pce) {
                if (debug.warningEnabled()) {
                    debug.warning("SOAPClient:send parser config exception", pce);
                }
            }
            catch (SAXException saxe) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("SOAPClient:send SAX exception", saxe);
            }
        }
        if (handler.isException()) {
            throw handler.getException();
        }
        return handler.getObject();
    }

    public void setURL(String url) {
        this.urls = new String[1];
        this.urls[0] = url;
    }

    void setURLs(String[] urls) {
        this.urls = urls;
    }

    String encodeString(String str) {
        return this.encodeString("String_1", str);
    }

    String encodeInt(String name, Integer i) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"xsd:int\">");
        sb.append(i).append("</").append(name).append(">");
        return sb.toString();
    }

    String encodeInt(Integer i) {
        return this.encodeInt("int_1", i);
    }

    String encodeBoolean(String name, Boolean b) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"xsd:boolean\">");
        sb.append(b).append("</").append(name).append(">");
        return sb.toString();
    }

    String encodeBoolean(Boolean b) {
        return this.encodeBoolean("boolean_1", b);
    }

    String encodeString(String name, String str) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"xsd:string\">");
        String data = SOAPClient.escapeSpecialCharacters(str);
        sb.append(data).append("</").append(name).append(">");
        return sb.toString();
    }

    String encodeSet(Set set) {
        return this.encodeSet("Set_1", set);
    }

    String encodeSet(String name, Set set) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"ns1:hashSet\" enc:arrayType=\"xsd:anyType[");
        sb.append(set.size());
        sb.append("]\">");
        Iterator items = set.iterator();
        while (items.hasNext()) {
            sb.append(this.encodeString(ITEM, items.next().toString()));
        }
        sb.append("</").append(name).append(">");
        return sb.toString();
    }

    String encodeList(List list) {
        return this.encodeList("List_1", list);
    }

    String encodeList(String name, List list) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"ns1:linkedList\" enc:arrayType=\"xsd:anyType[");
        sb.append(list.size());
        sb.append("]\">");
        Iterator items = list.iterator();
        while (items.hasNext()) {
            sb.append(this.encodeString(ITEM, items.next().toString()));
        }
        sb.append("</").append(name).append(">");
        return sb.toString();
    }

    public String encodeMap(Map map) {
        return this.encodeMap("Map_1", map);
    }

    String encodeByteArrayArray(String name, byte[][] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("The provided byte array is null or empty");
        }
        HashSet<String> converted = new HashSet<String>(data.length);
        for (byte[] bytes : data) {
            converted.add(Base64.encode(bytes));
        }
        return this.encodeSet(name, converted);
    }

    public String encodeMap(String name, Map map) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"ns1:hashMap\" enc:arrayType=\"ns1:mapEntry[");
        sb.append(map.size()).append("]\">");
        for (Map.Entry entry : map.entrySet()) {
            sb.append("<item xsi:type=\"ns1:mapEntry\">");
            sb.append(this.encodeString(KEY, entry.getKey().toString()));
            Object value = entry.getValue();
            if (value instanceof Set) {
                sb.append(this.encodeSet(VALUE, (Set)value));
            } else if (value instanceof Map) {
                sb.append(this.encodeMap(VALUE, (Map)value));
            } else if (value instanceof List) {
                sb.append(this.encodeList(VALUE, (List)value));
            } else if (value instanceof String) {
                sb.append(this.encodeString(VALUE, (String)value));
            } else if (value instanceof byte[][]) {
                sb.append(this.encodeByteArrayArray(VALUE, (byte[][])value));
            }
            sb.append("</item>");
        }
        sb.append("</").append(name).append(">");
        return sb.toString();
    }

    public Map decodeMap(String xmlMap) {
        if (xmlMap == null || xmlMap.length() == 0) {
            return Collections.EMPTY_MAP;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append(DECODE_HEADER);
        sb.append(xmlMap);
        sb.append(DECODE_FOOTER);
        SOAPContentHandler handler = new SOAPContentHandler(false);
        try {
            SAXParser saxParser = XMLUtils.getSafeSAXParser(false);
            XMLReader parser = saxParser.getXMLReader();
            parser.setContentHandler(handler);
            parser.setErrorHandler(new SOAPErrorHandler());
            parser.parse(new InputSource(new ByteArrayInputStream(sb.toString().getBytes("UTF-8"))));
        }
        catch (Exception e) {
            if (debug.warningEnabled()) {
                debug.warning("SOAPClient::decodeMap Exception", e);
            }
            return Collections.EMPTY_MAP;
        }
        return (Map)handler.getObject();
    }

    public String encodeMessage(String function, Object param) {
        Object[] params = null;
        if (param != null) {
            params = new Object[]{param};
        }
        return this.encodeMessage(function, params);
    }

    public String encodeMessage(String function, Object[] params) {
        int index = 1;
        StringBuffer sb = new StringBuffer(1000);
        sb.append(ENVELOPE).append(HEADSTART).append(HEADEND).append(ENV_BODY);
        sb.append("<ans1:").append(function).append(" xmlns:ans1=\"http://isp.com/wsdl\">");
        for (int i = 0; params != null && i < params.length; ++i) {
            if (params[i] instanceof String) {
                sb.append(this.encodeString("String_" + index++, (String)params[i]));
                continue;
            }
            if (params[i] instanceof Set) {
                sb.append(this.encodeSet("Set_" + index++, (Set)params[i]));
                continue;
            }
            if (params[i] instanceof Map) {
                sb.append(this.encodeMap("Map_" + index++, (Map)params[i]));
                continue;
            }
            if (params[i] instanceof List) {
                sb.append(this.encodeList("List_" + index++, (List)params[i]));
                continue;
            }
            if (params[i] instanceof Integer) {
                sb.append(this.encodeInt("int_" + index++, (Integer)params[i]));
                continue;
            }
            if (params[i] instanceof Boolean) {
                sb.append(this.encodeBoolean("boolean_" + index++, (Boolean)params[i]));
                continue;
            }
            if (params[i] == null) {
                ++index;
                continue;
            }
            debug.error("SOAPClient: Unknown class: " + params.getClass().getName());
        }
        sb.append("</ans1:").append(function).append(">").append(SUFFIX);
        return sb.toString();
    }

    private static String escapeSpecialCharacters(String txt) {
        if (txt == null || txt.length() == 0) {
            return txt;
        }
        StringBuffer buf = new StringBuffer();
        int len = txt.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = txt.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block8;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block8;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block8;
                }
                case '/': {
                    buf.append("&#47;");
                    continue block8;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    class SOAPResponseObject {
        private InputStream response;
        private boolean exception;

        SOAPResponseObject(InputStream is, boolean exception) {
            this.response = is;
            this.exception = exception;
        }

        InputStream getResponse() {
            return this.response;
        }

        boolean isException() {
            return this.exception;
        }
    }

    class SOAPErrorHandler
    implements ErrorHandler {
        SOAPErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXParseException {
            debug.error("SOAPClient:PARSER.fatalError", spe);
        }

        @Override
        public void error(SAXParseException spe) throws SAXParseException {
        }

        @Override
        public void warning(SAXParseException spe) throws SAXParseException {
        }
    }

    class SOAPContentHandler
    implements ContentHandler {
        Locator locator;
        boolean started;
        List types;
        List maps;
        List keys;
        Object answer;
        String currentType;
        String type;
        StringBuffer currentString;
        Set set;
        Set currentSet;
        Map map;
        List list;
        List currentList;
        String exceptionClassName;
        String exceptionMessage;
        String exceptionCode;
        String smsExceptionCode;
        int ldapErrorCode;
        String resourceBundleName;
        String errorString;
        Set messageArgs;
        Exception exception;
        boolean isException;

        protected SOAPContentHandler(boolean isException) {
            this.isException = isException;
            this.types = new LinkedList();
            this.maps = new LinkedList();
            this.keys = new LinkedList();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected Exception getException() {
            return this.exception;
        }

        protected boolean isException() {
            return this.isException;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
            if (!this.started && localName.equalsIgnoreCase(SOAPClient.BODY)) {
                this.started = true;
                return;
            }
            if (!this.isException) {
                if (localName.equalsIgnoreCase(SOAPClient.RESULT)) {
                    this.type = this.currentType = attrs.getValue(attrs.getIndex(SOAPClient.TYPE));
                    if (this.type.equalsIgnoreCase(SOAPClient.SET)) {
                        this.set = this.currentSet = new OrderedSet();
                    } else if (this.type.equalsIgnoreCase(SOAPClient.TREESET)) {
                        this.set = this.currentSet = new TreeSet();
                    } else if (this.type.equalsIgnoreCase(SOAPClient.MAP)) {
                        this.map = new HashMap();
                        this.maps.add(0, this.map);
                    } else if (this.type.equalsIgnoreCase(SOAPClient.LIST)) {
                        this.list = this.currentList = new LinkedList();
                    }
                } else if (localName.equalsIgnoreCase(SOAPClient.ITEM)) {
                    this.types.add(0, this.currentType);
                    this.currentType = attrs.getValue(attrs.getIndex(SOAPClient.TYPE));
                } else if (localName.equalsIgnoreCase(SOAPClient.VALUE)) {
                    this.types.add(0, this.currentType);
                    this.currentType = attrs.getValue(attrs.getIndex(SOAPClient.TYPE));
                    if (this.currentType.equalsIgnoreCase(SOAPClient.SET)) {
                        this.currentSet = new OrderedSet();
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.MAP)) {
                        this.maps.add(0, new HashMap());
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.LIST)) {
                        this.currentList = new LinkedList();
                    }
                }
            } else if (localName.equals(SOAPClient.ARRAY_OF_ANY_TYPE) || localName.equalsIgnoreCase(SOAPClient.ARRAY_OF_STRING_TYPE)) {
                this.messageArgs = new OrderedSet();
            }
            if (this.currentString == null) {
                this.currentString = new StringBuffer();
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            if (!this.started) {
                return;
            }
            if (!this.isException) {
                if (localName.equalsIgnoreCase(SOAPClient.ITEM)) {
                    if (this.currentType.equalsIgnoreCase(SOAPClient.STRING)) {
                        if (this.currentSet != null) {
                            this.currentSet.add(this.currentString.toString());
                        } else {
                            this.currentList.add(this.currentString.toString());
                        }
                    }
                    this.currentType = (String)this.types.remove(0);
                } else if (localName.equalsIgnoreCase(SOAPClient.VALUE)) {
                    if (this.currentType.equalsIgnoreCase(SOAPClient.SET) || this.currentType.equalsIgnoreCase(SOAPClient.TREESET)) {
                        Map map1 = (Map)this.maps.get(0);
                        map1.put(this.keys.remove(0), this.currentSet);
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.MAP)) {
                        Map map1 = (Map)this.maps.remove(0);
                        Map map2 = (Map)this.maps.get(0);
                        map2.put(this.keys.remove(0), map1);
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.LIST)) {
                        Map map1 = (Map)this.maps.get(0);
                        map1.put(this.keys.remove(0), this.currentList);
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.STRING) && ((String)this.types.get(0)).equalsIgnoreCase(SOAPClient.MAPENTRY)) {
                        this.map.put(this.keys.remove(0), this.currentString.toString());
                    }
                    this.currentType = (String)this.types.remove(0);
                } else if (localName.equals(SOAPClient.KEY)) {
                    this.keys.add(0, this.currentString.toString());
                } else if (localName.equalsIgnoreCase(SOAPClient.RESULT)) {
                    if (this.type.equalsIgnoreCase(SOAPClient.SET) || this.type.equalsIgnoreCase(SOAPClient.TREESET)) {
                        this.answer = this.set;
                    } else if (this.type.equalsIgnoreCase(SOAPClient.MAP)) {
                        this.answer = this.map;
                    } else if (this.type.equalsIgnoreCase(SOAPClient.STRING)) {
                        this.answer = this.currentString.toString();
                    } else if (this.type.equalsIgnoreCase(SOAPClient.INTEGER)) {
                        try {
                            this.answer = new Integer(this.currentString.toString());
                        }
                        catch (NumberFormatException nfe) {
                            this.answer = new Integer(0);
                        }
                    } else if (this.type.equalsIgnoreCase(SOAPClient.BOOLEAN)) {
                        this.answer = new Boolean(this.currentString.toString());
                    } else if (this.type.equalsIgnoreCase(SOAPClient.LIST)) {
                        this.answer = this.list;
                    }
                }
            } else if (localName.equals(SOAPClient.FAULT_STRING)) {
                this.exceptionClassName = this.currentString.toString();
            } else if (localName.equals(SOAPClient.MESSAGE)) {
                this.exceptionMessage = this.currentString.toString();
            } else if (localName.equals(SOAPClient.ERROR_CODE)) {
                this.exceptionCode = this.currentString.toString();
            } else if (localName.equals(SOAPClient.EXCEPTION_CODE)) {
                this.smsExceptionCode = this.currentString.toString();
            } else if (localName.equals(SOAPClient.RESOURCE_BUNDLE_NAME)) {
                this.resourceBundleName = this.currentString.toString();
            } else if (localName.equals(SOAPClient.ITEM)) {
                this.messageArgs.add(this.currentString.toString());
            } else if (localName.equals(SOAPClient.LDAP_ERROR_CODE)) {
                this.ldapErrorCode = Integer.parseInt(this.currentString.toString());
            } else if (localName.equals(SOAPClient.ERROR_STRING)) {
                this.errorString = this.currentString.toString();
            }
            this.currentString = null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentString.append(ch, start, length);
        }

        Object getObject() {
            return this.answer;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.isException) {
                this.exception = null;
                try {
                    Class<?> clazz = Class.forName(this.exceptionClassName);
                    if (clazz != null) {
                        this.exception = this.createResourceBasedException(clazz);
                        if (this.exception == null) {
                            this.exception = this.createCodeBasedException(clazz);
                        }
                        if (this.exception == null) {
                            this.exception = this.createSMSCodeBasedException(clazz);
                        }
                        if (this.exception == null) {
                            this.exception = this.createMessageBasedException(clazz);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    debug.error("JAXRPCHelper.endDocument", e);
                }
                if (this.exception == null) {
                    this.exception = this.exceptionMessage != null ? new Exception(this.exceptionMessage) : new Exception("unknown-exception");
                }
            }
        }

        private Exception createResourceBasedException(Class clazz) {
            Exception exception = null;
            if (this.resourceBundleName != null && this.exceptionCode != null) {
                try {
                    if (clazz.getName().equals("com.sun.identity.idm.IdRepoException") && this.ldapErrorCode > 0) {
                        Class[] params = new Class[]{String.class, String.class, String.class, Object[].class};
                        Constructor ctr = clazz.getConstructor(params);
                        Object[] objs = new Object[]{this.resourceBundleName, this.exceptionCode, String.valueOf(this.ldapErrorCode), this.messageArgs != null ? this.messageArgs.toArray() : null};
                        exception = (Exception)ctr.newInstance(objs);
                    } else {
                        Class[] params = new Class[]{String.class, String.class, Object[].class};
                        Constructor ctr = clazz.getConstructor(params);
                        Object[] objs = new Object[]{this.resourceBundleName, this.exceptionCode, this.messageArgs != null ? this.messageArgs.toArray() : null};
                        exception = (Exception)ctr.newInstance(objs);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return exception;
        }

        private Exception createCodeBasedException(Class clazz) {
            Exception exception = null;
            if (this.exceptionCode != null && this.exceptionMessage != null) {
                try {
                    Class[] params = new Class[]{Integer.TYPE, String.class};
                    Constructor ctr = clazz.getConstructor(params);
                    int intCode = Integer.parseInt(this.exceptionCode);
                    Object[] objs = new Object[]{new Integer(intCode), this.exceptionMessage};
                    exception = (Exception)ctr.newInstance(objs);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return exception;
        }

        private Exception createSMSCodeBasedException(Class clazz) {
            Exception exception = null;
            if (this.exceptionClassName.equals(SOAPClient.SMSEXCEPTION) && this.smsExceptionCode != null) {
                try {
                    Class[] params = new Class[]{Integer.TYPE, String.class};
                    Constructor ctr = clazz.getConstructor(params);
                    int intCode = Integer.parseInt(this.smsExceptionCode);
                    Object[] objs = new Object[]{new Integer(intCode), null};
                    exception = (Exception)ctr.newInstance(objs);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (SecurityException securityException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return exception;
        }

        private Exception createMessageBasedException(Class clazz) {
            Exception exception = null;
            try {
                Class[] params = new Class[]{String.class};
                Constructor ctr = clazz.getConstructor(params);
                Object[] objs = new Object[]{this.exceptionMessage != null ? this.exceptionMessage : "no message"};
                exception = (Exception)ctr.newInstance(objs);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return exception;
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String url) {
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }
}

