/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.debug.file.impl;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.file.DebugConfiguration;
import com.sun.identity.shared.debug.file.DebugFile;
import com.sun.identity.shared.debug.file.impl.StdDebugFile;
import com.sun.identity.shared.locale.Locale;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.forgerock.openam.utils.IOUtils;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.util.time.TimeService;

public class DebugFileImpl
implements DebugFile {
    private final TimeService clock;
    private final String debugName;
    private volatile PrintWriter debugWriter = null;
    private long fileCreationTime = 0L;
    private long nextRotation = 0L;
    private final SimpleDateFormat suffixDateFormat;
    private final DebugConfiguration configuration;
    private final AtomicReference<String> debugDirectory = new AtomicReference();
    private final ReadWriteLock fileLock = new ReentrantReadWriteLock();
    private File currentFile;

    public DebugFileImpl(DebugConfiguration configuration, String debugName) {
        this(configuration, debugName, TimeService.SYSTEM);
    }

    public DebugFileImpl(DebugConfiguration configuration, String debugName, TimeService clock) {
        this.debugName = debugName;
        this.clock = clock;
        this.configuration = configuration;
        SimpleDateFormat tmpSuffixDateFormat = null;
        if (!configuration.getDebugSuffix().isEmpty()) {
            try {
                tmpSuffixDateFormat = new SimpleDateFormat(configuration.getDebugSuffix());
            }
            catch (IllegalArgumentException iae) {
                String message = "An error occurred with the date format suffix : '" + configuration.getDebugSuffix() + "'. Please check the configuration file '" + "/debugconfig.properties" + "'.";
                StdDebugFile.printError(debugName, message, iae);
                tmpSuffixDateFormat = new SimpleDateFormat("-MM.dd.yyyy-kk.mm");
            }
        }
        this.suffixDateFormat = tmpSuffixDateFormat;
    }

    private boolean isConfigChanged() throws IOException {
        String newDebugDir = SystemPropertiesManager.get("com.iplanet.services.debug.directory");
        if (StringUtils.isEmpty(newDebugDir)) {
            ResourceBundle bundle = Locale.getInstallResourceBundle("amUtilMsgs");
            throw new IOException(bundle.getString("com.iplanet.services.debug.nodir") + " Current Debug File : " + this);
        }
        this.fileLock.readLock().lock();
        try {
            boolean bl = !newDebugDir.equals(this.debugDirectory.getAndSet(newDebugDir));
            return bl;
        }
        finally {
            this.fileLock.readLock().unlock();
        }
    }

    private boolean isConfigFileInitialized() {
        return this.currentFile != null && this.currentFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeIt(String prefix, String msg, Throwable th) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(prefix);
        buf.append('\n');
        buf.append(msg);
        if (th != null) {
            buf.append('\n');
            StringWriter stBuf = new StringWriter(300);
            PrintWriter stackStream = new PrintWriter(stBuf);
            th.printStackTrace(stackStream);
            stackStream.flush();
            buf.append(stBuf.toString());
        }
        if (this.isConfigChanged() || !this.isConfigFileInitialized()) {
            this.initialize();
        }
        if (this.needsTimeRotation() || this.needsSizeRotation()) {
            this.rotate();
        }
        this.fileLock.readLock().lock();
        try {
            if (this.debugWriter != null) {
                this.debugWriter.println(buf.toString());
            } else {
                StdDebugFile.printError(prefix, msg, th);
            }
        }
        finally {
            this.fileLock.readLock().unlock();
        }
    }

    private void close() {
        IOUtils.closeIfNotNull((Closeable)this.debugWriter);
        this.debugWriter = null;
        this.currentFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String wrapFilename(String fileName) {
        StringBuilder newFileName = new StringBuilder();
        if (this.configuration.getDebugPrefix() != null) {
            newFileName.append(this.configuration.getDebugPrefix());
        }
        newFileName.append(fileName);
        if (this.suffixDateFormat != null && (this.configuration.getRotationInterval() > 0 || this.configuration.getRotationFileSizeInByte() > 0L)) {
            SimpleDateFormat simpleDateFormat = this.suffixDateFormat;
            synchronized (simpleDateFormat) {
                newFileName.append(this.suffixDateFormat.format(new Date(this.fileCreationTime)));
            }
        }
        return newFileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws IOException {
        this.fileLock.writeLock().lock();
        try {
            this.close();
            this.fileCreationTime = this.clock.now();
            if (this.configuration.getRotationFileSizeInByte() == -1L) {
                this.fileCreationTime -= this.fileCreationTime % 60000L;
            }
            this.nextRotation = this.fileCreationTime + (long)(this.configuration.getRotationInterval() * 60 * 1000);
            boolean directoryAvailable = false;
            String debugDir = this.debugDirectory.get();
            if (debugDir != null && debugDir.trim().length() > 0) {
                File dir = new File(debugDir);
                if (!dir.exists()) {
                    directoryAvailable = dir.mkdirs();
                } else if (dir.isDirectory() && dir.canWrite()) {
                    directoryAvailable = true;
                }
            }
            if (!directoryAvailable) {
                ResourceBundle bundle = Locale.getInstallResourceBundle("amUtilMsgs");
                throw new IOException(bundle.getString("com.iplanet.services.debug.nodir") + " Current Debug File : " + this);
            }
            String debugFilePath = this.debugDirectory.get() + File.separator + this.wrapFilename(this.debugName);
            try {
                this.currentFile = new File(debugFilePath);
                this.debugWriter = new PrintWriter((Writer)new FileWriter(this.currentFile, true), true);
                this.debugWriter = new PrintWriter((Writer)new FileWriter(debugFilePath, true), true);
            }
            catch (IOException ioex) {
                this.close();
                ResourceBundle bundle = Locale.getInstallResourceBundle("amUtilMsgs");
                throw new IOException(bundle.getString("com.iplanet.services.debug.nofile") + " Current Debug File : " + this, ioex);
            }
        }
        finally {
            this.fileLock.writeLock().unlock();
        }
    }

    private boolean needsSizeRotation() {
        this.fileLock.readLock().lock();
        try {
            if (this.currentFile != null) {
                boolean bl = this.configuration.getRotationFileSizeInByte() != -1L && this.currentFile.length() >= this.configuration.getRotationFileSizeInByte();
                return bl;
            }
        }
        finally {
            this.fileLock.readLock().unlock();
        }
        return false;
    }

    private boolean needsTimeRotation() {
        this.fileLock.readLock().lock();
        try {
            if (this.configuration != null) {
                boolean bl = this.configuration.getRotationInterval() > 0 && this.nextRotation <= this.clock.now();
                return bl;
            }
        }
        finally {
            this.fileLock.readLock().unlock();
        }
        return false;
    }

    private synchronized void rotate() throws IOException {
        if (this.needsTimeRotation() || this.needsSizeRotation()) {
            this.initialize();
        }
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz");
        return "DebugFileImpl{debugDirectory" + this.debugDirectory.get() + "debugName='" + this.debugName + '\'' + ", fileCreationTime=" + dateFormat.format(new Date(this.fileCreationTime)) + '}';
    }
}

