/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.debug;

import java.security.InvalidParameterException;

public enum DebugLevel {
    OFF(0, "off"),
    ERROR(1, "error"),
    WARNING(2, "warning"),
    MESSAGE(3, "message"),
    ON(4, "on");

    private int level;
    private String name;

    private DebugLevel(int level, String name) {
        this.level = level;
        this.name = name;
    }

    public static DebugLevel fromName(String strName) {
        return DebugLevel.valueOf(strName.toUpperCase());
    }

    public static DebugLevel fromLevel(int strLevel) throws InvalidParameterException {
        if (DebugLevel.OFF.level == strLevel) {
            return OFF;
        }
        if (DebugLevel.ERROR.level == strLevel) {
            return ERROR;
        }
        if (DebugLevel.WARNING.level == strLevel) {
            return WARNING;
        }
        if (DebugLevel.MESSAGE.level == strLevel) {
            return MESSAGE;
        }
        if (DebugLevel.ON.level == strLevel) {
            return ON;
        }
        throw new IllegalArgumentException("level '" + strLevel + "' isn't defined");
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public int compareLevel(DebugLevel o) {
        if (this.level == o.level) {
            return 0;
        }
        if (this.level < o.level) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return this.name;
    }
}

