/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared;

import java.util.regex.Matcher;

public class StringUtils {
    public static final String AMPERSAND = "&";
    public static final String ESCAPE_AMPERSAND = "&#38;";
    public static final String PROPERTY_VALUE_DELIMITER = "|";
    public static final String ESCAPE_DELIMITER = "&#124;";

    private StringUtils() {
    }

    public static String strReplaceAll(String orig, String pattern, String str) {
        return orig.replaceAll(pattern, Matcher.quoteReplacement(str));
    }

    public static String getEscapedValue(String value) {
        if (value != null) {
            return value.replaceAll(AMPERSAND, ESCAPE_AMPERSAND).replaceAll("\\|", ESCAPE_DELIMITER);
        }
        return null;
    }

    public static String getUnescapedValue(String value) {
        if (value != null) {
            return value.replaceAll(ESCAPE_DELIMITER, PROPERTY_VALUE_DELIMITER).replaceAll(ESCAPE_AMPERSAND, AMPERSAND);
        }
        return null;
    }
}

