/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtils {
    private JSONUtils() {
    }

    public static Set<String> getSet(JSONObject json, String key) throws JSONException {
        if (!json.has(key)) {
            return null;
        }
        HashSet<String> results = new HashSet<String>();
        JSONArray values = json.getJSONArray(key);
        for (int i = 0; i < values.length(); ++i) {
            results.add((String)values.get(i));
        }
        return results;
    }

    public static Map<String, Set<String>> getMapStringSetString(JSONObject json, String key) throws JSONException {
        if (!json.has(key)) {
            return null;
        }
        HashMap<String, Set<String>> results = new HashMap<String, Set<String>>();
        JSONObject js = (JSONObject)json.opt(key);
        Iterator i = js.keys();
        while (i.hasNext()) {
            String k = (String)i.next();
            Object test = js.opt(k);
            if (test instanceof JSONArray) {
                JSONArray values = (JSONArray)test;
                HashSet<String> set = new HashSet<String>();
                results.put(k, set);
                for (int j = 0; j < values.length(); ++j) {
                    set.add((String)values.get(j));
                }
                continue;
            }
            if (test instanceof Boolean) {
                HashSet<String> set = new HashSet<String>();
                results.put(k, set);
                set.add(test.toString());
                continue;
            }
            if (!test.equals(JSONObject.NULL)) continue;
            results.put(k, null);
        }
        return results;
    }

    public static Map<String, Boolean> getMapStringBoolean(JSONObject json, String key) throws JSONException {
        if (!json.has(key)) {
            return null;
        }
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        JSONObject js = (JSONObject)json.opt(key);
        Iterator i = js.keys();
        while (i.hasNext()) {
            String k = (String)i.next();
            results.put(k, (Boolean)js.opt(k));
        }
        return results;
    }

    public static long getLong(JSONObject json, String key) throws JSONException {
        if (!json.has(key)) {
            return 0L;
        }
        String str = json.getString(key);
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

