/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.keystore.v_14;

import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.keystore.AMX509KeyManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public class AMX509KeyManagerImpl
implements AMX509KeyManager {
    static final String bundleName = "amSecurity";
    static ResourceBundle bundle = null;
    static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    public static Debug debug = SecurityDebug.debug;
    static String keyStoreFile = System.getProperty("javax.net.ssl.keyStore", null);
    static String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "");
    String certAlias = null;
    X509KeyManager sunX509KeyManager = null;
    KeyStore keyStore = null;
    KeyManagerFactory kmf = null;
    static String provider = null;
    static String algorithm = null;

    public AMX509KeyManagerImpl() {
        try {
            bundle = amCache.getResBundle(bundleName, Locale.getDefault());
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream(keyStoreFile);
            ks.load(fis, keyStorePassword.toCharArray());
            this.kmf = KeyManagerFactory.getInstance(algorithm, provider);
            this.kmf.init(ks, keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            debug.error("AMX509KeyManager.AMX509KeyManager:", e);
        }
        this.sunX509KeyManager = (X509KeyManager)this.kmf.getKeyManagers()[0];
    }

    @Override
    public void setAlias(String alias) {
        this.certAlias = alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket sock) {
        if (debug.messageEnabled()) {
            debug.message("AMX509KeyManagerImpl.chooseClientAlias: certAlias = " + this.certAlias);
        }
        if (this.certAlias != null && this.certAlias.length() > 0) {
            return this.certAlias;
        }
        return this.sunX509KeyManager.chooseClientAlias(keyType, issuers, sock);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket sock) {
        return this.sunX509KeyManager.chooseServerAlias(keyType, issuers, sock);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.sunX509KeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.sunX509KeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.sunX509KeyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.sunX509KeyManager.getPrivateKey(alias);
    }

    static {
        Provider[] sProviders = Security.getProviders();
        for (int i = 0; i < sProviders.length; ++i) {
            if (!sProviders[i].getName().equalsIgnoreCase("IBMJSSE")) continue;
            provider = "IBMJSSE";
            algorithm = "IbmX509";
        }
        if (provider == null) {
            provider = "SunJSSE";
            algorithm = "SunX509";
        }
    }
}

