/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.TimerPool;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import org.forgerock.util.thread.listener.ShutdownListener;

public class SystemTimerPool {
    public static final String TIMER_NAME = "SystemTimerPool";
    public static final String SCHEDULER_NAME = "SystemTimerPool-Scheduler";
    protected static TimerPool instance;
    public static final int DEFAULT_POOL_SIZE = 3;
    private static int poolSize;

    public static synchronized TimerPool getTimerPool() {
        if (instance == null) {
            ShutdownManager shutdownMan = ShutdownManager.getInstance();
            instance = new TimerPool(TIMER_NAME, poolSize, false, Debug.getInstance(TIMER_NAME));
            try {
                shutdownMan.addShutdownListener(new ShutdownListener(){

                    public void shutdown() {
                        instance.shutdown();
                        instance = null;
                    }
                });
            }
            catch (IllegalMonitorStateException e) {
                instance.shutdown();
                instance = null;
                throw e;
            }
        }
        return instance;
    }

    static {
        poolSize = 3;
        String size = SystemPropertiesManager.get("com.sun.identity.common.systemtimerpool.size");
        if (size != null) {
            try {
                poolSize = Integer.parseInt(size);
            }
            catch (NumberFormatException ex) {
                Debug debug = Debug.getInstance(TIMER_NAME);
                debug.error("SystemTimerPool.<init>: incorrect pool size " + size + " defaulting to " + 3);
            }
        }
    }
}

