/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.ScheduleableAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PeriodicRunnable
extends GeneralTaskRunnable {
    protected Set thisTurn;
    protected Set[] nextTurn;
    protected long runPeriod;
    protected long timeoutPeriod;
    protected int containerNeeded;
    protected boolean removeElementAfterAction;

    public PeriodicRunnable(long runPeriod, long timeoutPeriod, boolean removeElementAfterAction) throws IllegalArgumentException {
        if (runPeriod < 0L || timeoutPeriod < 0L) {
            throw new IllegalArgumentException();
        }
        this.containerNeeded = (int)(timeoutPeriod / runPeriod);
        if (timeoutPeriod % runPeriod > 0L) {
            ++this.containerNeeded;
        }
        this.runPeriod = runPeriod;
        this.timeoutPeriod = timeoutPeriod;
        this.removeElementAfterAction = removeElementAfterAction;
        this.thisTurn = new HashSet();
        this.nextTurn = new HashSet[this.containerNeeded];
        for (int i = 0; i < this.containerNeeded; ++i) {
            this.nextTurn[i] = new HashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addElement(Object obj) {
        Set set = this.nextTurn[this.containerNeeded - 1];
        synchronized (set) {
            return this.nextTurn[this.containerNeeded - 1].add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeElement(Object obj) {
        Set set = this.nextTurn[this.containerNeeded - 1];
        synchronized (set) {
            if (!this.nextTurn[this.containerNeeded - 1].remove(obj)) {
                for (int i = this.containerNeeded - 2; i >= 0; --i) {
                    if (!this.nextTurn[i].remove(obj)) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        set = this.thisTurn;
        synchronized (set) {
            return this.thisTurn.remove(obj);
        }
    }

    public long getTimeoutPeriod() {
        return this.timeoutPeriod;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public long getRunPeriod() {
        return this.runPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Set set = this.thisTurn;
        synchronized (set) {
            if (!this.thisTurn.isEmpty()) {
                Iterator iter = this.thisTurn.iterator();
                while (iter.hasNext()) {
                    ScheduleableAction action = (ScheduleableAction)iter.next();
                    action.doAction();
                    if (!this.removeElementAfterAction) continue;
                    iter.remove();
                }
            }
        }
        set = this.nextTurn[this.containerNeeded - 1];
        synchronized (set) {
            Set tempSet = this.thisTurn;
            for (int i = 0; i < this.containerNeeded + 1; ++i) {
                if (i == 0) {
                    this.thisTurn = this.nextTurn[0];
                    continue;
                }
                if (i == this.containerNeeded) {
                    this.nextTurn[this.containerNeeded - 1] = tempSet;
                    continue;
                }
                this.nextTurn[i - 1] = this.nextTurn[i];
            }
        }
    }
}

