/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.TaskRunnable;
import com.sun.identity.common.Triggerable;
import java.util.Date;

public class HeadTaskRunnable
implements TaskRunnable {
    protected Date time;
    protected volatile TaskRunnable nextTask;
    protected volatile TaskRunnable tailTask;
    protected volatile boolean expired;
    protected volatile boolean timeout;
    protected int waitCount;
    protected int acquireCount;
    protected volatile Thread owner;
    protected Triggerable parent;

    public HeadTaskRunnable(Triggerable parent, TaskRunnable nextTask, Date time) throws IllegalArgumentException {
        if (time == null || nextTask == null) {
            throw new IllegalArgumentException();
        }
        this.time = time;
        this.owner = null;
        this.nextTask = nextTask;
        this.tailTask = nextTask;
        this.expired = false;
        this.timeout = false;
        this.waitCount = 0;
        this.acquireCount = 0;
        this.nextTask.setHeadTask(this);
        this.nextTask.setPrevious(this);
        this.parent = parent;
    }

    protected synchronized void expire() throws IllegalMonitorStateException {
        if (this.owner != Thread.currentThread()) {
            throw new IllegalMonitorStateException("The calling thread is not the owner of the lock!");
        }
        this.expired = true;
    }

    protected synchronized void timeout() throws IllegalMonitorStateException {
        if (this.owner != Thread.currentThread()) {
            throw new IllegalMonitorStateException("The calling thread is not the owner of the lock!");
        }
        this.timeout = true;
    }

    public boolean isTimedOut() {
        return this.timeout;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Thread getCurrentOwner() {
        return this.owner;
    }

    public synchronized boolean acquireValidLock() {
        while (!this.expired) {
            if (this.owner == null) {
                this.owner = Thread.currentThread();
                this.acquireCount = 1;
                return true;
            }
            if (this.owner != Thread.currentThread()) {
                try {
                    ++this.waitCount;
                    this.wait();
                    --this.waitCount;
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            ++this.acquireCount;
            return true;
        }
        return false;
    }

    public synchronized void releaseLockAndNotify() throws IllegalMonitorStateException {
        if (this.owner == Thread.currentThread()) {
            if (this.acquireCount > 1) {
                --this.acquireCount;
            } else {
                this.owner = null;
                this.acquireCount = 0;
                if (this.waitCount > 0) {
                    if (this.expired) {
                        this.notifyAll();
                    } else {
                        this.notify();
                    }
                }
            }
        } else {
            throw new IllegalMonitorStateException("The calling thread is not the owner of the lock!");
        }
    }

    @Override
    public void setHeadTask(HeadTaskRunnable headTask) {
    }

    @Override
    public HeadTaskRunnable getHeadTask() {
        return null;
    }

    @Override
    public boolean addElement(Object key) {
        return false;
    }

    @Override
    public boolean removeElement(Object key) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNext(TaskRunnable task) {
        if (task == null) {
            HeadTaskRunnable headTaskRunnable = this;
            synchronized (headTaskRunnable) {
                if (this.parent != null) {
                    this.parent.trigger(this.time);
                }
            }
            this.nextTask = null;
        } else {
            this.nextTask = task;
        }
    }

    @Override
    public void setPrevious(TaskRunnable task) {
    }

    @Override
    public TaskRunnable next() {
        return this.nextTask;
    }

    @Override
    public TaskRunnable previous() {
        return null;
    }

    @Override
    public long getRunPeriod() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (this.acquireValidLock()) {
            try {
                HeadTaskRunnable headTaskRunnable = this;
                synchronized (headTaskRunnable) {
                    if (this.parent != null) {
                        this.parent.trigger(this.time);
                    }
                }
            }
            finally {
                this.releaseLockAndNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrigger(Triggerable parent) {
        HeadTaskRunnable headTaskRunnable = this;
        synchronized (headTaskRunnable) {
            this.parent = parent;
        }
    }

    public void setTail(TaskRunnable task) {
        this.tailTask = task;
    }

    public TaskRunnable tail() {
        return this.tailTask;
    }

    @Override
    public long scheduledExecutionTime() {
        if (this.expired) {
            return -1L;
        }
        return this.time.getTime();
    }

    @Override
    public void run() {
        TaskRunnable taskToRun = this.next();
        do {
            taskToRun.run();
        } while ((taskToRun = taskToRun.next()) != null);
    }
}

