/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.HeadTaskRunnable;
import com.sun.identity.common.TaskRunnable;

public abstract class GeneralTaskRunnable
implements TaskRunnable {
    protected volatile TaskRunnable nextTask;
    protected volatile TaskRunnable previousTask;
    protected volatile HeadTaskRunnable headTask;

    @Override
    public void setHeadTask(HeadTaskRunnable headTask) {
        this.headTask = headTask;
    }

    @Override
    public HeadTaskRunnable getHeadTask() {
        return this.headTask;
    }

    @Override
    public TaskRunnable previous() {
        return this.previousTask;
    }

    @Override
    public TaskRunnable next() {
        return this.nextTask;
    }

    @Override
    public void setPrevious(TaskRunnable task) {
        this.previousTask = task;
    }

    @Override
    public void setNext(TaskRunnable task) {
        this.nextTask = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long scheduledExecutionTime() {
        GeneralTaskRunnable generalTaskRunnable = this;
        synchronized (generalTaskRunnable) {
            if (this.headTask != null) {
                return this.headTask.scheduledExecutionTime();
            }
        }
        return -1L;
    }

    public boolean isScheduled() {
        return this.scheduledExecutionTime() != -1L;
    }

    @Override
    public void cancel() {
        HeadTaskRunnable oldHeadTask = null;
        do {
            if ((oldHeadTask = this.headTask) == null || !oldHeadTask.acquireValidLock()) continue;
            try {
                if (oldHeadTask != this.headTask) continue;
                if (oldHeadTask.isTimedOut()) break;
                this.previousTask.setNext(this.nextTask);
                if (this.nextTask != null) {
                    this.nextTask.setPrevious(this.previousTask);
                    this.nextTask = null;
                    break;
                }
                oldHeadTask.setTail(this.previousTask);
                break;
            }
            finally {
                oldHeadTask.releaseLockAndNotify();
            }
        } while (oldHeadTask != this.headTask);
        this.headTask = null;
    }
}

