/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.sun.identity.shared.debug.Debug;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

public class CertUtils {
    public static final String COMMON_NAME = "CN";
    public static final String MAIL = "MAIL";
    public static final String EMAIL_ADDRESS = "E";
    public static final String UID = "uid";
    private static final Map<String, String> OID_MAP = new HashMap<String, String>();
    private static final Debug DEBUG = Debug.getInstance("amAuthCert");

    public static String getSubjectName(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return cert.getSubjectX500Principal().getName("RFC2253", OID_MAP);
    }

    public static String getIssuerName(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return cert.getIssuerX500Principal().getName("RFC2253", OID_MAP);
    }

    public static String getAttributeValue(X500Principal principal, String attributeName) {
        try {
            LdapName ldapName = new LdapName(principal.getName("RFC2253", OID_MAP));
            for (Rdn rdn : ldapName.getRdns()) {
                Attributes attrs = rdn.toAttributes();
                NamingEnumeration<? extends Attribute> values = attrs.getAll();
                while (values.hasMoreElements()) {
                    Attribute attr = values.next();
                    if (!attributeName.equalsIgnoreCase(attr.getID())) continue;
                    return attr.get() == null ? null : attr.get().toString();
                }
            }
        }
        catch (NamingException ne) {
            DEBUG.warning("A naming error occurred while trying to retrieve " + attributeName + " from principal: " + principal, ne);
        }
        return null;
    }

    static {
        OID_MAP.put("1.2.840.113549.1.9.1", EMAIL_ADDRESS);
        OID_MAP.put("1.2.840.113549.1.9.2", "unstructuredName");
        OID_MAP.put("1.2.840.113549.1.9.8", "unstructuredAddress");
        OID_MAP.put("2.5.4.4", "sn");
        OID_MAP.put("2.5.4.5", "serialNumber");
        OID_MAP.put("2.5.4.12", "title");
        OID_MAP.put("2.5.4.42", "givenName");
        OID_MAP.put("2.5.4.43", "initials");
        OID_MAP.put("2.5.4.44", "generationQualifier");
        OID_MAP.put("2.5.4.46", "dnQualifier");
    }
}

