/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Cache
extends Dictionary
implements Map {
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private transient Entry[] table;
    private transient int maxSize;
    private transient LRUList lruTracker;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public Cache(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (capacity == 0) {
            capacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[capacity];
        this.threshold = (int)((float)capacity * loadFactor);
        this.maxSize = capacity;
        this.lruTracker = new LRUList();
    }

    public Cache(int capacity) {
        this(capacity, 0.75f);
        this.maxSize = capacity;
        this.lruTracker = new LRUList();
    }

    public Cache() {
        this(10000, 0.75f);
        this.maxSize = 10000;
        this.lruTracker = new LRUList();
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new Enumerator(0, false);
    }

    public synchronized Enumeration elements() {
        return new Enumerator(1, false);
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Object get(Object key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                this.lruTracker.replaceLast(e);
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                this.lruTracker.replaceLast(e);
                return old;
            }
            e = e.next;
        }
        e = null;
        if (this.count == this.maxSize) {
            e = this.lruTracker.getFirst();
            this.adjustEntry(e.key);
            this.lruTracker.replaceLast(e);
            e.changeValues(hash, key, value, tab[index]);
        } else {
            ++this.modCount;
            ++this.count;
            e = new Entry(hash, key, value, tab[index]);
            this.lruTracker.addLast(e);
        }
        tab[index] = e;
        return null;
    }

    protected void adjustEntry(Object key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
            }
            prev = e;
            e = e.next;
        }
    }

    public synchronized Object remove(Object key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                this.lruTracker.remove(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void putAll(Map t) {
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.lruTracker.clear();
        this.count = 0;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuilder buf = new StringBuilder();
        Iterator it = this.entrySet().iterator();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            Entry e = (Entry)it.next();
            buf.append(e.key).append("=").append(e.value);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public synchronized String audit() {
        String retStr = "";
        int ltl = this.lruTracker.length();
        if (ltl != this.count) {
            retStr = "LRU list length (" + ltl + ") != count (" + this.count + ")";
        }
        return retStr;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new SynchronizedSet(new KeySet(), (Object)this);
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new SynchronizedSet(new EntrySet(), (Object)this);
        }
        return this.entrySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new SynchronizedCollection(new ValueCollection(), this);
        }
        return this.values;
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        for (Entry e : this.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized int hashCode() {
        int h = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        SynchronizedSet(Set s) {
            super(s);
        }

        SynchronizedSet(Set s, Object mutex) {
            super(s, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }
    }

    static class SynchronizedCollection
    implements Collection {
        Collection c;
        Object mutex;

        SynchronizedCollection(Collection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.c = c;
            this.mutex = this;
        }

        SynchronizedCollection(Collection c, Object mutex) {
            this.c = c;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        @Override
        public Iterator iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }
    }

    private class Enumerator
    implements Enumeration,
    Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        boolean iterator;
        private int expectedModCount;

        Enumerator(int type, boolean iterator) {
            this.table = Cache.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = Cache.this.modCount;
            this.type = type;
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                Entry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return this.type == 0 ? e.key : (this.type == 1 ? e.value : e);
            }
            throw new NoSuchElementException("Cache Enumerator");
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            if (Cache.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Cache Enumerator");
            }
            if (Cache.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Cache cache = Cache.this;
            synchronized (cache) {
                Entry[] tab = Cache.this.table;
                int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
                Entry e = tab[index];
                Entry prev = null;
                while (e != null) {
                    if (e == this.lastReturned) {
                        Cache.this.modCount++;
                        ++this.expectedModCount;
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        Cache.this.count--;
                        this.lastReturned = null;
                        return;
                    }
                    prev = e;
                    e = e.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;
        Entry lruNext;
        Entry lruPrev;

        protected Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
            this.lruNext = null;
            this.lruPrev = null;
        }

        protected synchronized Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        protected void changeValues(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class LRUList {
        Entry header = new Entry(0, null, null, null);
        int size;

        protected LRUList() {
        }

        protected LRUList(Entry h) {
            this.header = h;
        }

        protected void addLast(Entry e) {
            if (this.header.lruNext == null) {
                this.header.lruNext = this.header.lruPrev = e;
                e.lruNext = e.lruPrev = this.header;
            } else {
                this.header.lruPrev.lruNext = e;
                e.lruNext = this.header;
                e.lruPrev = this.header.lruPrev;
                this.header.lruPrev = e;
            }
            ++this.size;
        }

        protected void remove(Entry e) {
            if (e == null) {
                return;
            }
            e.lruPrev.lruNext = e.lruNext;
            e.lruNext.lruPrev = e.lruPrev;
            e.lruPrev = null;
            e.lruNext = null;
            --this.size;
        }

        protected Entry getFirst() {
            return this.header.lruNext;
        }

        protected Entry getLast() {
            return this.header.lruPrev;
        }

        protected Entry removeFirst() {
            Entry first = this.header.lruNext;
            this.remove(first);
            return first;
        }

        protected void replaceLast(Entry e) {
            this.remove(e);
            this.addLast(e);
        }

        protected int length() {
            return this.size;
        }

        protected void clear() {
            this.header = new Entry(0, null, null, null);
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        @Override
        public Iterator iterator() {
            return new Enumerator(1, true);
        }

        @Override
        public int size() {
            return Cache.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Cache.this.containsValue(o);
        }

        @Override
        public void clear() {
            Cache.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new Enumerator(2, true);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry[] tab = Cache.this.table;
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry[] tab = Cache.this.table;
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    Cache.this.modCount++;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    Cache.this.count--;
                    e.value = null;
                    return true;
                }
                prev = e;
                e = e.next;
            }
            return false;
        }

        @Override
        public int size() {
            return Cache.this.count;
        }

        @Override
        public void clear() {
            Cache.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new Enumerator(0, true);
        }

        @Override
        public int size() {
            return Cache.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Cache.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return Cache.this.remove(o) != null;
        }

        @Override
        public void clear() {
            Cache.this.clear();
        }
    }
}

