/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.notifications.brokers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.forgerock.json.JsonValue;
import org.forgerock.openam.audit.context.AMExecutorServiceFactory;
import org.forgerock.openam.notifications.Consumer;
import org.forgerock.openam.notifications.NotificationBroker;
import org.forgerock.openam.notifications.Subscription;
import org.forgerock.openam.notifications.Topic;
import org.forgerock.util.Reject;
import org.forgerock.util.time.TimeService;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryNotificationBroker
implements NotificationBroker {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryNotificationBroker.class);
    private static final DateTimeFormatter TS_FORMATTER = ISODateTimeFormat.dateTime().withZoneUTC();
    private final BlockingQueue<NotificationEntry> queue;
    private final List<InternalSubscription> subscriptions;
    private final TimeService timeService;
    private final ExecutorService executorService;
    private volatile boolean shutdown;

    @Inject
    public InMemoryNotificationBroker(AMExecutorServiceFactory executorServiceFactory, TimeService timeService, @Named(value="queueSize") int queueSize, @Named(value="consumers") int consumers) {
        Reject.ifNull((Object)executorServiceFactory, (String)"Executor service factory must not be null");
        Reject.ifNull((Object)timeService, (String)"Time service must not be null");
        Reject.ifTrue((queueSize <= 0 ? 1 : 0) != 0, (String)"Queue size must be a positive integer");
        Reject.ifTrue((consumers <= 0 ? 1 : 0) != 0, (String)"Number of consumer threads must be a positive integer");
        this.timeService = timeService;
        this.queue = new ArrayBlockingQueue<NotificationEntry>(queueSize);
        this.subscriptions = new CopyOnWriteArrayList<InternalSubscription>();
        this.executorService = executorServiceFactory.createFixedThreadPool(consumers, "InMemoryNotificationsBroker");
        for (int i = 0; i < consumers; ++i) {
            this.executorService.submit(new NotificationReader());
        }
    }

    @Override
    public boolean publish(Topic topic, JsonValue notification) {
        Reject.ifNull((Object)topic, (String)"Topic must not be null");
        Reject.ifNull((Object)notification, (String)"Notification must not be null");
        if (this.shutdown) {
            logger.info("Not publishing notification as broker shutting down");
            return false;
        }
        NotificationEntry entry = NotificationEntry.of(topic, this.packageNotification(topic, notification));
        if (!this.queue.offer(entry)) {
            logger.info("Failed to publish notification because queue is full. Notification discarded");
            return false;
        }
        return true;
    }

    private JsonValue packageNotification(Topic topic, JsonValue notification) {
        String timeStamp = TS_FORMATTER.print((ReadableInstant)new DateTime(this.timeService.now()));
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"topic", (Object)topic.getIdentifier()), JsonValue.field((String)"timestamp", (Object)timeStamp), JsonValue.field((String)"body", (Object)notification.getObject())}));
    }

    @Override
    public Subscription subscribe(Consumer consumer) {
        Reject.ifNull((Object)consumer, (String)"Consumer must not be null");
        InternalSubscription subscription = new InternalSubscription(consumer);
        this.subscriptions.add(subscription);
        return subscription;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        this.executorService.shutdownNow();
    }

    private static final class NotificationEntry {
        private final Topic topic;
        private final JsonValue notification;

        private NotificationEntry(Topic topic, JsonValue notification) {
            this.topic = topic;
            this.notification = notification;
        }

        static NotificationEntry of(Topic topic, JsonValue notification) {
            return new NotificationEntry(topic, notification);
        }
    }

    private final class InternalSubscription
    implements Subscription {
        private final Set<Topic> topics;
        private final Consumer consumer;
        private volatile boolean closed;

        private InternalSubscription(Consumer consumer) {
            this.consumer = consumer;
            this.topics = new CopyOnWriteArraySet<Topic>();
        }

        @Override
        public Subscription bindTo(Topic topic) {
            Reject.rejectStateIfTrue((boolean)this.closed, (String)"Subscription is closed");
            Reject.ifNull((Object)topic, (String)"Topic must not be null");
            this.topics.add(topic);
            return this;
        }

        @Override
        public boolean isBoundTo(Topic topic) {
            Reject.rejectStateIfTrue((boolean)this.closed, (String)"Subscription is closed");
            Reject.ifNull((Object)topic, (String)"Topic must not be null");
            return this.topics.contains(topic);
        }

        @Override
        public Subscription unbindFrom(Topic topic) {
            Reject.rejectStateIfTrue((boolean)this.closed, (String)"Subscription is closed");
            Reject.ifNull((Object)topic, (String)"Topic must not be null");
            this.topics.remove(topic);
            return this;
        }

        @Override
        public void close() {
            this.closed = true;
            InMemoryNotificationBroker.this.subscriptions.remove(this);
        }

        void consumeIfApplicable(Topic topic, JsonValue notification) {
            if (this.consumer == null) {
                return;
            }
            if (this.isBoundTo(topic)) {
                this.consumer.accept(notification);
            }
        }
    }

    private final class NotificationReader
    implements Runnable {
        private NotificationReader() {
        }

        @Override
        public void run() {
            while (!InMemoryNotificationBroker.this.shutdown) {
                try {
                    NotificationEntry entry = (NotificationEntry)InMemoryNotificationBroker.this.queue.poll(10L, TimeUnit.SECONDS);
                    if (entry == null) continue;
                    this.deliver(entry);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    InMemoryNotificationBroker.this.shutdown = true;
                    break;
                }
            }
            ArrayList remainingEntries = new ArrayList();
            InMemoryNotificationBroker.this.queue.drainTo(remainingEntries);
            for (NotificationEntry entry : remainingEntries) {
                this.deliver(entry);
            }
        }

        private void deliver(NotificationEntry entry) {
            for (InternalSubscription subscription : InMemoryNotificationBroker.this.subscriptions) {
                try {
                    subscription.consumeIfApplicable(entry.topic, entry.notification);
                }
                catch (RuntimeException ex) {
                    logger.warn("Exception thrown whilst delivering notifications", (Throwable)ex);
                }
            }
        }
    }
}

