/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.monitoring.cts;

import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.forgerock.openam.monitoring.cts.TokenEntryMBean;
import org.forgerock.openam.monitoring.cts.TokenEntryMeta;

public class TokenTableMeta
extends SnmpMibTable
implements Serializable {
    private TokenEntryMeta node;
    protected SnmpStandardObjectServer objectserver;

    public TokenTableMeta(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib);
        this.objectserver = objserv;
    }

    protected TokenEntryMeta createTokenEntryMetaNode(String snmpEntryName, String tableName, SnmpMib mib, MBeanServer server) {
        return new TokenEntryMeta(mib, this.objectserver);
    }

    public void createNewEntry(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        if (this.factory == null) {
            throw new SnmpStatusException(6);
        }
        this.factory.createNewEntry(req, rowOid, depth, (SnmpMibTable)this);
    }

    public boolean isRegistrationRequired() {
        return false;
    }

    public void registerEntryNode(SnmpMib mib, MBeanServer server) {
        this.node = this.createTokenEntryMetaNode("TokenEntry", "TokenTable", mib, server);
    }

    public synchronized void addEntry(SnmpOid rowOid, ObjectName objname, Object entry) throws SnmpStatusException {
        if (!(entry instanceof TokenEntryMBean)) {
            throw new ClassCastException("Entries for Table \"TokenTable\" must implement the \"TokenEntryMBean\" interface.");
        }
        super.addEntry(rowOid, objname, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        TokenEntryMBean entry = (TokenEntryMBean)this.getEntry(rowOid);
        TokenTableMeta tokenTableMeta = this;
        synchronized (tokenTableMeta) {
            this.node.setInstance(entry);
            this.node.get(req, depth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        if (req.getSize() == 0) {
            return;
        }
        TokenEntryMBean entry = (TokenEntryMBean)this.getEntry(rowOid);
        TokenTableMeta tokenTableMeta = this;
        synchronized (tokenTableMeta) {
            this.node.setInstance(entry);
            this.node.set(req, depth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        if (req.getSize() == 0) {
            return;
        }
        TokenEntryMBean entry = (TokenEntryMBean)this.getEntry(rowOid);
        TokenTableMeta tokenTableMeta = this;
        synchronized (tokenTableMeta) {
            this.node.setInstance(entry);
            this.node.check(req, depth);
        }
    }

    public void validateVarEntryId(SnmpOid rowOid, long var, Object data) throws SnmpStatusException {
        this.node.validateVarId(var, data);
    }

    public boolean isReadableEntryId(SnmpOid rowOid, long var, Object data) throws SnmpStatusException {
        return this.node.isReadable(var);
    }

    public long getNextVarEntryId(SnmpOid rowOid, long var, Object data) throws SnmpStatusException {
        long nextvar = this.node.getNextVarId(var, data);
        while (!this.isReadableEntryId(rowOid, nextvar, data)) {
            nextvar = this.node.getNextVarId(nextvar, data);
        }
        return nextvar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean skipEntryVariable(SnmpOid rowOid, long var, Object data, int pduVersion) {
        try {
            TokenEntryMBean entry = (TokenEntryMBean)this.getEntry(rowOid);
            TokenTableMeta tokenTableMeta = this;
            synchronized (tokenTableMeta) {
                this.node.setInstance(entry);
                return this.node.skipVariable(var, data, pduVersion);
            }
        }
        catch (SnmpStatusException x) {
            return false;
        }
    }
}

