/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.monitoring.cts;

import com.sun.management.snmp.SnmpCounter64;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpIndex;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpTableSupport;
import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.forgerock.openam.monitoring.cts.CtsTokenOperationsEntry;
import org.forgerock.openam.monitoring.cts.CtsTokenOperationsEntryMBean;

public class TableCtsTokenOperationsTable
extends SnmpTableSupport
implements Serializable {
    protected MBeanServer server;

    public TableCtsTokenOperationsTable(SnmpMib myMib) {
        super(myMib);
    }

    public TableCtsTokenOperationsTable(SnmpMib myMib, MBeanServer server) {
        this(myMib);
        this.server = server;
    }

    public void createNewEntry(SnmpMibSubRequest req, SnmpOid rowOid, int depth, SnmpMibTable meta) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(rowOid);
        Vector v = index.getComponents();
        try {
            SnmpOid oid0 = (SnmpOid)v.elementAt(0);
            ObjectName objname = null;
            if (this.server != null) {
                objname = this.buildNameFromIndex(index);
            }
            Object entry = this.createCtsTokenOperationsEntryMBean(req, rowOid, depth, objname, meta, oid0.toLong());
            if (this.server != null) {
                this.server.registerMBean(entry, objname);
            }
            meta.addEntry(rowOid, objname, entry);
        }
        catch (SnmpStatusException e) {
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    protected SnmpMibTable getRegisteredTableMeta(SnmpMib mib) {
        return mib.getRegisteredTableMeta("CtsTokenOperationsTable");
    }

    public void removeEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        try {
            super.removeEntryCb(pos, row, name, entry, meta);
            if (this.server != null && name != null) {
                this.server.unregisterMBean(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void addEntry(CtsTokenOperationsEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, (Object)entry);
    }

    public synchronized void addEntry(CtsTokenOperationsEntryMBean entry, ObjectName name) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, name, (Object)entry);
    }

    public synchronized CtsTokenOperationsEntryMBean[] getEntries() {
        Object[] array = this.getBasicEntries();
        CtsTokenOperationsEntryMBean[] result = new CtsTokenOperationsEntryMBean[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public void removeEntry(CtsTokenOperationsEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.removeEntry(index, (Object)entry);
    }

    public ObjectName buildNameFromIndex(SnmpIndex index) throws SnmpStatusException {
        Vector v = index.getComponents();
        try {
            SnmpOid oid = (SnmpOid)v.elementAt(0);
            String _keyTokenTableIndex = oid.toLong().toString();
            return new ObjectName("TableCtsTokenOperationsTable:name=org.forgerock.openam.monitoring.cts.CtsTokenOperationsEntry,TokenTableIndex=" + _keyTokenTableIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    public SnmpIndex buildSnmpIndex(CtsTokenOperationsEntryMBean entry) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[1];
        SnmpCounter64 val = null;
        val = new SnmpCounter64(entry.getTokenTableIndex());
        oids[0] = val.toOid();
        return new SnmpIndex(oids);
    }

    public SnmpOid buildOidFromIndex(SnmpIndex index) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        if (index.getNbComponents() != 1) {
            throw new SnmpStatusException(224);
        }
        try {
            Vector v = index.getComponents();
            SnmpCounter64.appendToOid((SnmpOid)((SnmpOid)v.elementAt(0)), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpOid buildOidFromIndexVal(Long aTokenTableIndex) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        try {
            SnmpCounter64.appendToOid((SnmpOid)new SnmpCounter64(aTokenTableIndex).toOid(), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpIndex buildSnmpIndex(long[] index, int start) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[1];
        int pos = start;
        oids[0] = SnmpCounter64.toOid((long[])index, (int)pos);
        return new SnmpIndex(oids);
    }

    public Object createCtsTokenOperationsEntryMBean(SnmpMibSubRequest req, SnmpOid rowOid, int depth, ObjectName entryObjName, SnmpMibTable meta, Long aTokenTableIndex) throws SnmpStatusException {
        CtsTokenOperationsEntry entry = new CtsTokenOperationsEntry(this.theMib);
        entry.TokenTableIndex = aTokenTableIndex;
        return entry;
    }
}

