/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.monitoring.cts;

import com.sun.management.snmp.SnmpCounter64;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpIndex;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpTableSupport;
import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.forgerock.openam.monitoring.cts.CtsCRUDOperationsPerTokenTypeEntry;
import org.forgerock.openam.monitoring.cts.CtsCRUDOperationsPerTokenTypeEntryMBean;

public class TableCtsCRUDOperationsPerTokenTypeTable
extends SnmpTableSupport
implements Serializable {
    protected MBeanServer server;

    public TableCtsCRUDOperationsPerTokenTypeTable(SnmpMib myMib) {
        super(myMib);
    }

    public TableCtsCRUDOperationsPerTokenTypeTable(SnmpMib myMib, MBeanServer server) {
        this(myMib);
        this.server = server;
    }

    public void createNewEntry(SnmpMibSubRequest req, SnmpOid rowOid, int depth, SnmpMibTable meta) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(rowOid);
        Vector v = index.getComponents();
        try {
            SnmpOid oid0 = (SnmpOid)v.elementAt(0);
            SnmpOid oid1 = (SnmpOid)v.elementAt(1);
            ObjectName objname = null;
            if (this.server != null) {
                objname = this.buildNameFromIndex(index);
            }
            Object entry = this.createCtsCRUDOperationsPerTokenTypeEntryMBean(req, rowOid, depth, objname, meta, oid0.toLong(), oid1.toLong());
            if (this.server != null) {
                this.server.registerMBean(entry, objname);
            }
            meta.addEntry(rowOid, objname, entry);
        }
        catch (SnmpStatusException e) {
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    protected SnmpMibTable getRegisteredTableMeta(SnmpMib mib) {
        return mib.getRegisteredTableMeta("CtsCRUDOperationsPerTokenTypeTable");
    }

    public void removeEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        try {
            super.removeEntryCb(pos, row, name, entry, meta);
            if (this.server != null && name != null) {
                this.server.unregisterMBean(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void addEntry(CtsCRUDOperationsPerTokenTypeEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, (Object)entry);
    }

    public synchronized void addEntry(CtsCRUDOperationsPerTokenTypeEntryMBean entry, ObjectName name) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, name, (Object)entry);
    }

    public synchronized CtsCRUDOperationsPerTokenTypeEntryMBean[] getEntries() {
        Object[] array = this.getBasicEntries();
        CtsCRUDOperationsPerTokenTypeEntryMBean[] result = new CtsCRUDOperationsPerTokenTypeEntryMBean[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public void removeEntry(CtsCRUDOperationsPerTokenTypeEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.removeEntry(index, (Object)entry);
    }

    public ObjectName buildNameFromIndex(SnmpIndex index) throws SnmpStatusException {
        Vector v = index.getComponents();
        try {
            SnmpOid oid = (SnmpOid)v.elementAt(0);
            String _keyTokenTableIndex = oid.toLong().toString();
            oid = (SnmpOid)v.elementAt(1);
            String _keyOperationTableIndex = oid.toLong().toString();
            return new ObjectName("TableCtsCRUDOperationsPerTokenTypeTable:name=org.forgerock.openam.monitoring.cts.CtsCRUDOperationsPerTokenTypeEntry,TokenTableIndex=" + _keyTokenTableIndex + ",OperationTableIndex=" + _keyOperationTableIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    public SnmpIndex buildSnmpIndex(CtsCRUDOperationsPerTokenTypeEntryMBean entry) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[2];
        SnmpCounter64 val = null;
        val = new SnmpCounter64(entry.getTokenTableIndex());
        oids[0] = val.toOid();
        val = new SnmpCounter64(entry.getOperationTableIndex());
        oids[1] = val.toOid();
        return new SnmpIndex(oids);
    }

    public SnmpOid buildOidFromIndex(SnmpIndex index) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        if (index.getNbComponents() != 2) {
            throw new SnmpStatusException(224);
        }
        try {
            Vector v = index.getComponents();
            SnmpCounter64.appendToOid((SnmpOid)((SnmpOid)v.elementAt(0)), (SnmpOid)oid);
            SnmpCounter64.appendToOid((SnmpOid)((SnmpOid)v.elementAt(1)), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpOid buildOidFromIndexVal(Long aTokenTableIndex, Long aOperationTableIndex) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        try {
            SnmpCounter64.appendToOid((SnmpOid)new SnmpCounter64(aTokenTableIndex).toOid(), (SnmpOid)oid);
            SnmpCounter64.appendToOid((SnmpOid)new SnmpCounter64(aOperationTableIndex).toOid(), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpIndex buildSnmpIndex(long[] index, int start) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[2];
        int pos = start;
        oids[0] = SnmpCounter64.toOid((long[])index, (int)pos);
        pos = SnmpCounter64.nextOid((long[])index, (int)pos);
        oids[1] = SnmpCounter64.toOid((long[])index, (int)pos);
        return new SnmpIndex(oids);
    }

    public Object createCtsCRUDOperationsPerTokenTypeEntryMBean(SnmpMibSubRequest req, SnmpOid rowOid, int depth, ObjectName entryObjName, SnmpMibTable meta, Long aTokenTableIndex, Long aOperationTableIndex) throws SnmpStatusException {
        CtsCRUDOperationsPerTokenTypeEntry entry = new CtsCRUDOperationsPerTokenTypeEntry(this.theMib);
        entry.TokenTableIndex = aTokenTableIndex;
        entry.OperationTableIndex = aOperationTableIndex;
        return entry;
    }
}

