/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.license;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ResourceBundle;
import org.forgerock.openam.license.User;

public class ConsoleUser
implements User {
    private static final String LICENSE_PROPERTIES = "LicensePresenter";
    private final PrintWriter out;
    private final BufferedReader in;
    private final ResourceBundle messages;

    public ConsoleUser(Writer out, Reader in, ResourceBundle messages) {
        if (out == null) {
            throw new NullPointerException("output stream is null");
        }
        if (in == null) {
            throw new NullPointerException("input stream is null");
        }
        if (messages == null) {
            throw new NullPointerException("message bundle is null");
        }
        this.out = new PrintWriter(out);
        this.in = new BufferedReader(in);
        this.messages = messages;
    }

    public ConsoleUser() {
        this(new PrintWriter(System.out), new InputStreamReader(System.in), ResourceBundle.getBundle(LICENSE_PROPERTIES));
    }

    @Override
    public void tell(String messageId) {
        this.show(this.messages.getString(messageId));
    }

    @Override
    public void show(String message) {
        this.out.println(message);
    }

    @Override
    public String ask(String question) {
        String response;
        try {
            do {
                this.out.print(this.messages.getString(question) + " ");
                this.out.flush();
            } while ((response = this.in.readLine()) != null && response.trim().isEmpty());
        }
        catch (IOException ex) {
            response = null;
        }
        return response;
    }

    @Override
    public String getName() {
        return System.getProperty("user.name");
    }

    @Override
    public String getMessage(String messageId) {
        return this.messages.getString(messageId);
    }
}

