/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.license;

import com.google.inject.Inject;
import org.forgerock.openam.license.License;
import org.forgerock.openam.license.LicenseLocator;
import org.forgerock.openam.license.LicensePresenter;
import org.forgerock.openam.license.LicenseSet;
import org.forgerock.openam.license.User;

public class CLILicensePresenter
implements LicensePresenter {
    private final LicenseLocator licenseModule;
    private final User user;
    private static final String YES = "yes";

    @Inject
    public CLILicensePresenter(LicenseLocator licenseModule, User user) {
        this.licenseModule = licenseModule;
        this.user = user;
    }

    @Override
    public void presentLicenses(boolean preAccept) {
        LicenseSet licenses = this.licenseModule.getRequiredLicenses();
        if (preAccept) {
            licenses.acceptAll();
        } else {
            for (License license : licenses) {
                if (license.isAccepted()) continue;
                this.user.show("");
                this.user.show(license.getLicenseText());
                String input = this.user.ask("prompt");
                if (input != null && YES.startsWith(input.toLowerCase())) {
                    license.accept();
                    continue;
                }
                license.reject();
            }
        }
    }

    @Override
    public String getNotice() {
        return this.user.getMessage("notice");
    }
}

