/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.ldap;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.openam.ldap.LDAPRequests;
import org.forgerock.openam.ldap.LDAPURL;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LoadBalancerEventListener;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.SearchResultReferenceIOException;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.time.Duration;

public final class LDAPUtils {
    public static final Option<Boolean> AFFINITY_ENABLED = Option.withDefault((Object)false);
    private static final char[] ESCAPED_CHAR = new char[]{',', '+', '\"', '\\', '<', '>', ';', '='};
    private static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    private static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    private static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private static final Map<String, SearchScope> SCOPES;
    private static final Debug DEBUG;
    private static final int DEFAULT_HEARTBEAT_TIMEOUT = 3;
    static final Pattern dnRule;

    private LDAPUtils() {
    }

    public static ConnectionFactory newPrioritizedFailoverConnectionPool(Set<String> servers, String hostServerId, String hostSiteId, String username, char[] password, int maxSize, int heartBeatInterval, String heartBeatTimeUnit, Options ldapOptions) {
        return LDAPUtils.newFailoverConnectionPool(LDAPUtils.prioritizeServers(servers, hostServerId, hostSiteId), username, password, maxSize, heartBeatInterval, heartBeatTimeUnit, ldapOptions);
    }

    public static ConnectionFactory newFailoverConnectionPool(Set<LDAPURL> servers, String username, char[] password, int maxSize, int heartBeatInterval, String heartBeatTimeUnit, Options ldapOptions) {
        ArrayList<ConnectionFactory> factories = new ArrayList<ConnectionFactory>(servers.size());
        for (LDAPURL ldapurl : servers) {
            ConnectionPool cf = Connections.newCachedConnectionPool((ConnectionFactory)LDAPUtils.newConnectionFactory(ldapurl, username, password, heartBeatInterval, heartBeatTimeUnit, ldapOptions), (int)1, (int)maxSize, (long)60L, (TimeUnit)TimeUnit.SECONDS);
            factories.add((ConnectionFactory)cf);
        }
        return LDAPUtils.loadBalanceFactories(factories, ldapOptions);
    }

    public static ConnectionFactory newPrioritizedFailoverConnectionFactory(Set<String> servers, String hostServerId, String hostSiteId, String username, char[] password, int heartBeatInterval, String heartBeatTimeUnit, Options options) {
        return LDAPUtils.newFailoverConnectionFactory(LDAPUtils.prioritizeServers(servers, hostServerId, hostSiteId), username, password, heartBeatInterval, heartBeatTimeUnit, options);
    }

    public static ConnectionFactory newFailoverConnectionFactory(Set<LDAPURL> servers, String username, char[] password, int heartBeatInterval, String heartBeatTimeUnit, Options ldapOptions) {
        ArrayList<ConnectionFactory> factories = new ArrayList<ConnectionFactory>(servers.size());
        for (LDAPURL ldapurl : servers) {
            factories.add(LDAPUtils.newConnectionFactory(ldapurl, username, password, heartBeatInterval, heartBeatTimeUnit, ldapOptions));
        }
        return LDAPUtils.loadBalanceFactories(factories, ldapOptions);
    }

    private static ConnectionFactory newConnectionFactory(LDAPURL ldapurl, String username, char[] password, int heartBeatInterval, String heartBeatTimeUnit, Options ldapOptions) {
        Boolean ssl = ldapurl.isSSL();
        int heartBeatTimeout = SystemPropertiesManager.getAsInt((String)"org.forgerock.openam.ldap.heartbeat.timeout", (int)3);
        if (ssl != null && ssl.booleanValue()) {
            String defaultProtocolVersion = SystemPropertiesManager.get((String)"org.forgerock.openam.ldap.secure.protocol.version", (String)"TLSv1");
            try {
                ldapOptions = Options.copyOf((Options)ldapOptions).set(LDAPConnectionFactory.SSL_CONTEXT, (Object)new SSLContextBuilder().setProtocol(defaultProtocolVersion).getSSLContext());
            }
            catch (GeneralSecurityException gse) {
                DEBUG.error("An error occurred while creating SSLContext", (Throwable)gse);
            }
        }
        if (heartBeatInterval > 0 && heartBeatTimeUnit != null) {
            TimeUnit unit = TimeUnit.valueOf(heartBeatTimeUnit.toUpperCase());
            ldapOptions = ldapOptions.set(LDAPConnectionFactory.HEARTBEAT_ENABLED, (Object)true).set(LDAPConnectionFactory.HEARTBEAT_INTERVAL, (Object)new Duration(Long.valueOf(unit.toSeconds(heartBeatInterval)), TimeUnit.SECONDS)).set(LDAPConnectionFactory.HEARTBEAT_TIMEOUT, (Object)new Duration(Long.valueOf(unit.toSeconds(heartBeatTimeout)), TimeUnit.SECONDS));
        }
        if (username != null) {
            ldapOptions = ldapOptions.set(LDAPConnectionFactory.AUTHN_BIND_REQUEST, (Object)LDAPRequests.newSimpleBindRequest(username, password));
        }
        return new LDAPConnectionFactory(ldapurl.getHost(), ldapurl.getPort(), ldapOptions);
    }

    private static ConnectionFactory loadBalanceFactories(List<ConnectionFactory> factories, Options options) {
        if (((Boolean)options.get(AFFINITY_ENABLED)).booleanValue()) {
            return Connections.newAffinityRequestLoadBalancer(factories, (Options)options);
        }
        return Connections.newFailoverLoadBalancer(factories, (Options)options);
    }

    public static Set<LDAPURL> prioritizeServers(Set<String> servers, String hostServerId, String hostSiteId) {
        LinkedHashSet<LDAPURL> ldapServers = new LinkedHashSet<LDAPURL>(servers.size());
        LinkedHashSet<LDAPURL> serverDefined = new LinkedHashSet<LDAPURL>(servers.size());
        LinkedHashSet<LDAPURL> siteDefined = new LinkedHashSet<LDAPURL>(servers.size());
        LinkedHashSet<LDAPURL> nonMatchingServers = new LinkedHashSet<LDAPURL>(servers.size());
        for (String server : servers) {
            StringTokenizer tokenizer = new StringTokenizer(server, "|");
            String ldapUrl = tokenizer.nextToken();
            String assignedServerId = "";
            String assignedSiteId = "";
            if (tokenizer.hasMoreTokens()) {
                assignedServerId = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreTokens()) {
                assignedSiteId = tokenizer.nextToken();
            }
            if (!assignedServerId.isEmpty() && assignedServerId.equals(hostServerId)) {
                serverDefined.add(LDAPURL.valueOf(ldapUrl));
                continue;
            }
            if (!assignedSiteId.isEmpty() && assignedSiteId.equals(hostSiteId)) {
                siteDefined.add(LDAPURL.valueOf(ldapUrl));
                continue;
            }
            nonMatchingServers.add(LDAPURL.valueOf(ldapUrl));
        }
        ldapServers.addAll(LDAPUtils.shuffle(serverDefined));
        ldapServers.addAll(LDAPUtils.shuffle(siteDefined));
        ldapServers.addAll(LDAPUtils.shuffle(nonMatchingServers));
        return ldapServers;
    }

    static Collection<LDAPURL> shuffle(Set<LDAPURL> servers) {
        if (servers.size() > 1) {
            ArrayList<LDAPURL> sortedRandom = new ArrayList<LDAPURL>(servers);
            Collections.shuffle(sortedRandom);
            return sortedRandom;
        }
        return servers;
    }

    public static SearchScope getSearchScope(String scope, SearchScope defaultScope) {
        SearchScope searchScope = SCOPES.get(scope);
        return searchScope == null ? defaultScope : searchScope;
    }

    public static Filter parseFilter(String filter, Filter defaultFilter) {
        try {
            return filter == null ? defaultFilter : Filter.valueOf((String)filter);
        }
        catch (LocalizedIllegalArgumentException liae) {
            DEBUG.error("Unable to construct Filter from " + filter + " -> " + liae.getMessage() + "\nFalling back to " + defaultFilter.toString());
            return defaultFilter;
        }
    }

    public static String getName(DN dn) {
        return dn.rdn().getFirstAVA().getAttributeValue().toString();
    }

    public static void addAttributeToMapAsByteArray(Attribute attribute, Map<String, byte[][]> map) {
        byte[][] values = new byte[attribute.size()][];
        int counter = 0;
        for (ByteString byteString : attribute) {
            byte[] bytes = byteString.toByteArray();
            values[counter++] = bytes;
        }
        map.put(attribute.getAttributeDescriptionAsString(), values);
    }

    public static void addAttributeToMapAsString(Attribute attribute, Map<String, Set<String>> map) {
        map.put(attribute.getAttributeDescriptionAsString(), LDAPUtils.getAttributeValuesAsStringSet(attribute));
    }

    public static Set<String> getAttributeValuesAsStringSet(Attribute attribute) {
        HashSet<String> values = new HashSet<String>(attribute.size());
        for (ByteString byteString : attribute) {
            values.add(byteString.toString());
        }
        return values;
    }

    public static Set<LDAPURL> convertToLDAPURLs(Set<String> servers) {
        if (servers == null) {
            return new LinkedHashSet<LDAPURL>(0);
        }
        LinkedHashSet<LDAPURL> ret = new LinkedHashSet<LDAPURL>(servers.size());
        for (String server : servers) {
            ret.add(LDAPURL.valueOf(server));
        }
        return ret;
    }

    public static String rdnValueFromDn(String dn) {
        return LDAPUtils.rdnValueFromDn(DN.valueOf((String)dn));
    }

    public static String rdnValueFromDn(DN dn) {
        if (dn.size() > 0) {
            return LDAPUtils.rdnValue(dn.rdn());
        }
        return "";
    }

    public static String rdnValue(RDN rdn) {
        Reject.ifTrue((boolean)rdn.isMultiValued(), (String)"Multivalued RDNs not supported");
        return rdn.getFirstAVA().getAttributeValue().toString();
    }

    public static String rdnTypeFromDn(String dn) {
        return LDAPUtils.rdnTypeFromDn(DN.valueOf((String)dn));
    }

    public static String rdnTypeFromDn(DN dn) {
        if (dn.size() > 0) {
            return LDAPUtils.rdnType(dn.rdn());
        }
        return "";
    }

    public static String rdnType(RDN rdn) {
        Reject.ifTrue((rdn.size() != 1 ? 1 : 0) != 0, (String)"Multivalued RDNs not supported");
        return rdn.getFirstAVA().getAttributeType().getNameOrOID();
    }

    public static Set<String> collectNonIdenticalValues(DN compare, Set<String> dns) throws InvalidNameException {
        HashSet<String> results = new HashSet<String>();
        for (String dnString : dns) {
            DN dn = DN.valueOf((String)dnString);
            if (dn.size() <= 0 || compare.compareTo(dn) == 0) continue;
            results.add(LDAPUtils.rdnValueFromDn(dn));
        }
        return results;
    }

    public static String getDBName(String suffix, Connection ld) {
        String filter = "cn=" + suffix;
        try {
            ConnectionEntryReader results = ld.search(LDAPRequests.newSearchRequest("cn=mapping tree,cn=config", SearchScope.WHOLE_SUBTREE, filter, new String[0]));
            while (results.hasNext()) {
                Attribute dbName = results.readEntry().getAttribute("nsslapd-backend");
                if (dbName == null) continue;
                return dbName.firstValueAsString();
            }
        }
        catch (LdapException results) {
        }
        catch (SearchResultReferenceIOException e) {
            DEBUG.error("LDAPUtils.getDBName: Did not expect to get a reference", (Throwable)e);
        }
        return "userRoot";
    }

    public static boolean isDN(String candidateDN) {
        return LDAPUtils.isDN(candidateDN, 0);
    }

    public static boolean isDN(String candidateDN, int minNumComponent) {
        try {
            return LDAPUtils.newDN(candidateDN).size() > minNumComponent;
        }
        catch (LocalizedIllegalArgumentException e) {
            DEBUG.error("LDAPUtils.isDN: Invalid DN", (Throwable)e);
            return false;
        }
    }

    public static String escapeValue(String str) {
        return DN.escapeAttributeValue((Object)str);
    }

    public static String unescapeValue(String str) {
        StringBuilder retbuf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char nextChar;
            char currentChar = str.charAt(i);
            if (currentChar == '\\' && LDAPUtils.isEscapeCharacter(nextChar = str.charAt(i + 1))) {
                currentChar = nextChar;
                ++i;
            }
            retbuf.append(currentChar);
        }
        return retbuf.toString();
    }

    private static boolean isEscapeCharacter(char c) {
        for (char escaped : ESCAPED_CHAR) {
            if (c != escaped) continue;
            return true;
        }
        return false;
    }

    public static String normalizeDN(String dn) {
        return LDAPUtils.newDN(dn).toString().toLowerCase();
    }

    public static DN newDN(String orgName) {
        if (orgName == null || orgName.startsWith("/") || !dnRule.matcher(orgName).matches()) {
            return DN.rootDN();
        }
        return DN.valueOf((String)orgName);
    }

    public static String formatToRFC(String dn) {
        return DN.valueOf((String)dn).toString().toLowerCase();
    }

    public static boolean dnEquals(String dn1, String dn2) {
        DN dnObj1 = DN.valueOf((String)dn1);
        DN dnObj2 = DN.valueOf((String)dn2);
        return dnObj1.equals((Object)dnObj2);
    }

    public static ConnectionFactory createFailoverConnectionFactory(String host, int defaultPort, String authDN, String authPasswd, Options options) {
        StringTokenizer st = new StringTokenizer(host);
        String[] hostList = new String[st.countTokens()];
        int[] portList = new int[st.countTokens()];
        int hostCount = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int colon = s.indexOf(58);
            if (colon > 0) {
                hostList[hostCount] = s.substring(0, colon);
                portList[hostCount] = Integer.parseInt(s.substring(colon + 1));
            } else {
                hostList[hostCount] = s;
                portList[hostCount] = defaultPort;
            }
            ++hostCount;
        }
        if (hostCount > 1) {
            ArrayList<ConnectionFactory> factories = new ArrayList<ConnectionFactory>();
            for (int i = 0; i < hostCount; ++i) {
                factories.add(LDAPUtils.createSingleHostConnectionFactory(hostList[i], portList[i], authDN, authPasswd, options));
            }
            return LDAPUtils.loadBalanceFactories(factories, options);
        }
        return LDAPUtils.createSingleHostConnectionFactory(hostList[0], portList[0], authDN, authPasswd, options);
    }

    private static ConnectionFactory createSingleHostConnectionFactory(String host, int port, String authDN, String authPasswd, Options options) {
        options = options.set(LDAPConnectionFactory.AUTHN_BIND_REQUEST, (Object)LDAPRequests.newSimpleBindRequest(authDN, authPasswd.toCharArray()));
        return new LDAPConnectionFactory(host, port, options);
    }

    static {
        DEBUG = Debug.getInstance((String)"LDAPUtils");
        HashMap<String, SearchScope> mappings = new HashMap<String, SearchScope>(3);
        mappings.put(LDAP_SCOPE_BASE, SearchScope.BASE_OBJECT);
        mappings.put(LDAP_SCOPE_ONE, SearchScope.SINGLE_LEVEL);
        mappings.put(LDAP_SCOPE_SUB, SearchScope.WHOLE_SUBTREE);
        SCOPES = Collections.unmodifiableMap(mappings);
        dnRule = Pattern.compile("^(?:[A-Za-z][\\w-]*|\\d+(?:\\.\\d+)*)=(?:#(?:[\\dA-Fa-f]{2})+|(?:[^,=\\+<>#;\\\\\"]|\\\\[,=\\+<>#;\\\\\"]|\\\\[\\dA-Fa-f]{2})*|\"(?:[^\\\\\"]|\\\\[,=\\+<>#;\\\\\"]|\\\\[\\dA-Fa-f]{2})*\")(?:\\+(?:[A-Za-z][\\w-]*|\\d+(?:\\.\\d+)*)=(?:#(?:[\\dA-Fa-f]{2})+|(?:[^,=\\+<>#;\\\\\"]|\\\\[,=\\+<>#;\\\\\"]|\\\\[\\dA-Fa-f]{2})*|\"(?:[^\\\\\"]|\\\\[,=\\+<>#;\\\\\"]|\\\\[\\dA-Fa-f]{2})*\"))*(?:,(?:[A-Za-z][\\w-]*|\\d+(?:\\.\\d+)*)=(?:#(?:[\\dA-Fa-f]{2})+|(?:[^,=\\+<>#;\\\\\"]|\\\\[,=\\+<>#;\\\\\"]|\\\\[\\dA-Fa-f]{2})*|\"(?:[^\\\\\"]|\\\\[,=\\+<>#;\\\\\"]|\\\\[\\dA-Fa-f]{2})*\")(?:\\+(?:[A-Za-z][\\w-]*|\\d+(?:\\.\\d+)*)=(?:#(?:[\\dA-Fa-f]{2})+|(?:[^,=\\+<>#;\\\\\"]|\\\\[,=\\+<>#;\\\\\"]|\\\\[\\dA-Fa-f]{2})*|\"(?:[^\\\\\"]|\\\\[,=\\+<>#;\\\\\"]|\\\\[\\dA-Fa-f]{2})*\"))*)*$");
    }

    private static class LoggingLBEventListener
    implements LoadBalancerEventListener {
        private LoggingLBEventListener() {
        }

        public void handleConnectionFactoryOffline(ConnectionFactory factory, LdapException error) {
            DEBUG.error("Connection factory became offline: " + factory, (Throwable)error);
        }

        public void handleConnectionFactoryOnline(ConnectionFactory factory) {
            DEBUG.error("Connection factory became online: " + factory);
        }
    }
}

