/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.audit.context;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.openam.audit.context.AMExecutorServiceFactory;
import org.forgerock.util.Reject;
import org.forgerock.util.thread.ExecutorServiceFactory;
import org.forgerock.util.thread.listener.ShutdownListener;
import org.forgerock.util.thread.listener.ShutdownManager;

class ExtendedExecutorServiceFactory
extends ExecutorServiceFactory
implements AMExecutorServiceFactory {
    private final ShutdownManager shutdownManager;

    ExtendedExecutorServiceFactory(ShutdownManager shutdownManager) {
        super(shutdownManager);
        this.shutdownManager = shutdownManager;
    }

    @Override
    public ScheduledExecutorService createScheduledService(int poolSize, String threadNamePrefix) {
        ScheduledExecutorService service = Executors.newScheduledThreadPool(poolSize, new NamedThreadFactory(threadNamePrefix));
        this.registerShutdown(service);
        return service;
    }

    @Override
    public ExecutorService createThreadPool(int coreSize, int maxSize, long idleTimeout, TimeUnit timeoutTimeunit, BlockingQueue<Runnable> runnables, String threadNamePrefix) {
        Reject.ifTrue((coreSize < 0 ? 1 : 0) != 0);
        Reject.ifTrue((maxSize < coreSize || maxSize <= 0 ? 1 : 0) != 0);
        Reject.ifTrue((idleTimeout < 0L ? 1 : 0) != 0);
        ThreadPoolExecutor service = new ThreadPoolExecutor(coreSize, maxSize, idleTimeout, timeoutTimeunit, runnables, new NamedThreadFactory(threadNamePrefix));
        this.registerShutdown(service);
        return service;
    }

    private void registerShutdown(final ExecutorService service) {
        this.shutdownManager.addShutdownListener(new ShutdownListener(){

            public void shutdown() {
                service.shutdownNow();
            }
        });
    }

    private class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger count = new AtomicInteger(0);
        private final String name;

        public NamedThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.name + "-" + this.count.getAndIncrement());
        }
    }
}

