/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.audit.context;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.forgerock.openam.audit.context.AMExecutorServiceFactory;
import org.forgerock.openam.audit.context.AuditRequestContextPropagatingExecutorService;
import org.forgerock.openam.audit.context.AuditRequestContextPropagatingScheduledExecutorService;
import org.forgerock.openam.audit.context.ExtendedExecutorServiceFactory;
import org.forgerock.util.thread.listener.ShutdownManager;

public class AuditRequestContextPropagatingExecutorServiceFactory
implements AMExecutorServiceFactory {
    private final AMExecutorServiceFactory delegate;

    public AuditRequestContextPropagatingExecutorServiceFactory(ShutdownManager shutdownManager) {
        this.delegate = new ExtendedExecutorServiceFactory(shutdownManager);
    }

    @Override
    public ScheduledExecutorService createScheduledService(int poolSize, String threadNamePrefix) {
        return this.decorate(this.delegate.createScheduledService(poolSize, threadNamePrefix));
    }

    @Override
    public ExecutorService createFixedThreadPool(int pool, ThreadFactory factory) {
        return this.decorate(this.delegate.createFixedThreadPool(pool, factory));
    }

    @Override
    public ExecutorService createFixedThreadPool(int pool, String threadName) {
        return this.decorate(this.delegate.createFixedThreadPool(pool, threadName));
    }

    @Override
    public ExecutorService createCachedThreadPool(ThreadFactory factory) {
        return this.decorate(this.delegate.createCachedThreadPool(factory));
    }

    @Override
    public ExecutorService createCachedThreadPool(String threadName) {
        return this.decorate(this.delegate.createCachedThreadPool(threadName));
    }

    @Override
    public ExecutorService createThreadPool(int coreSize, int maxSize, long idleTimeout, TimeUnit timeoutTimeunit, BlockingQueue<Runnable> runnables, String threadNamePrefix) {
        return this.decorate(this.delegate.createThreadPool(coreSize, maxSize, idleTimeout, timeoutTimeunit, runnables, threadNamePrefix));
    }

    private ExecutorService decorate(ExecutorService delegate) {
        return new AuditRequestContextPropagatingExecutorService(delegate);
    }

    private ScheduledExecutorService decorate(ScheduledExecutorService delegate) {
        return new AuditRequestContextPropagatingScheduledExecutorService(delegate);
    }
}

