/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.audit.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.forgerock.openam.audit.context.AuditRequestContextPropagatingCallable;
import org.forgerock.openam.audit.context.AuditRequestContextPropagatingRunnable;
import org.forgerock.openam.audit.context.ConfigurableExecutorService;
import org.forgerock.openam.audit.context.ExecutorServiceConfigurator;

public class AuditRequestContextPropagatingExecutorService
implements ConfigurableExecutorService {
    final ExecutorService delegate;

    public AuditRequestContextPropagatingExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
    }

    public ExecutorService getDelegate() {
        return this.delegate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(new AuditRequestContextPropagatingCallable<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(new AuditRequestContextPropagatingRunnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapAll(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapAll(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapAll(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapAll(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.wrap(command));
    }

    @Override
    public boolean isConfigurable() {
        return this.delegate instanceof ThreadPoolExecutor;
    }

    @Override
    public ExecutorServiceConfigurator getConfigurator() {
        if (!this.isConfigurable()) {
            throw new IllegalStateException("ExecutorService cannot be configured.");
        }
        return new ExecutorServiceConfigurator((ThreadPoolExecutor)this.delegate);
    }

    final Runnable wrap(Runnable delegate) {
        return new AuditRequestContextPropagatingRunnable(delegate);
    }

    final <T> Callable<T> wrap(Callable<T> delegate) {
        return new AuditRequestContextPropagatingCallable<T>(delegate);
    }

    final <T> Collection<? extends Callable<T>> wrapAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<AuditRequestContextPropagatingCallable<T>> results = new ArrayList<AuditRequestContextPropagatingCallable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            results.add(new AuditRequestContextPropagatingCallable<T>(task));
        }
        return results;
    }
}

