/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.audit.context;

import java.util.HashMap;
import java.util.Map;
import org.forgerock.services.TransactionId;
import org.forgerock.util.Reject;

public class AuditRequestContext {
    private static final ThreadLocal<AuditRequestContext> INSTANCES = new ThreadLocal<AuditRequestContext>(){

        @Override
        protected AuditRequestContext initialValue() {
            return new AuditRequestContext(new TransactionId());
        }
    };
    private final TransactionId transactionId;
    private final Map<String, String> properties;

    public AuditRequestContext(TransactionId transactionId) {
        this(transactionId, null);
    }

    public AuditRequestContext(TransactionId transactionId, Map<String, String> properties) {
        Reject.ifNull((Object)transactionId, (String)"TransactionId should not be null.");
        this.transactionId = transactionId;
        this.properties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
    }

    public AuditRequestContext copy() {
        return new AuditRequestContext(this.transactionId, this.properties);
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public static void putProperty(String key, String value) {
        AuditRequestContext.get().properties.put(key, value);
    }

    public static String getProperty(String key) {
        return AuditRequestContext.get().properties.get(key);
    }

    public static String removeProperty(String key) {
        return AuditRequestContext.get().properties.remove(key);
    }

    public static AuditRequestContext get() {
        return INSTANCES.get();
    }

    public static void set(AuditRequestContext auditRequestContext) {
        Reject.ifNull((Object)auditRequestContext, (String)"RequestContext should not be null.");
        INSTANCES.set(auditRequestContext);
    }

    public static void clear() {
        INSTANCES.remove();
    }

    public static String getTransactionIdValue() {
        return AuditRequestContext.get().getTransactionId().getValue();
    }

    public static String createSubTransactionIdValue() {
        return AuditRequestContext.get().getTransactionId().createSubTransactionId().getValue();
    }
}

