/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.audit.context;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.forgerock.guice.core.InjectorHolder;
import org.forgerock.openam.audit.context.AuditRequestContext;
import org.forgerock.openam.audit.context.TransactionIdConfiguration;
import org.forgerock.services.TransactionId;

public class AuditContextFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.setRequestContext(request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.clearRequestContext();
        }
    }

    public void destroy() {
    }

    private void setRequestContext(ServletRequest request) {
        String transactionIdHeader;
        TransactionIdConfiguration configuration;
        if (request instanceof HttpServletRequest && (configuration = (TransactionIdConfiguration)InjectorHolder.getInstance(TransactionIdConfiguration.class)).trustHttpTransactionHeader() && (transactionIdHeader = ((HttpServletRequest)request).getHeader("X-ForgeRock-TransactionId")) != null && !transactionIdHeader.trim().isEmpty()) {
            AuditRequestContext.set(new AuditRequestContext(new TransactionId(transactionIdHeader)));
        }
    }

    void clearRequestContext() {
        AuditRequestContext.clear();
    }
}

