/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.forgerock.util.query.QueryFilterVisitor;

public class QueryFilter<F> {
    private static final QueryFilterVisitor<StringBuilder, StringBuilder, Object> TO_STRING_VISITOR = new QueryFilterVisitor<StringBuilder, StringBuilder, Object>(){

        @Override
        public StringBuilder visitAndFilter(StringBuilder builder, List<QueryFilter<Object>> subFilters) {
            return this.visitCompositeFilter(" and ", builder, subFilters);
        }

        @Override
        public StringBuilder visitOrFilter(StringBuilder builder, List<QueryFilter<Object>> subFilters) {
            return this.visitCompositeFilter(" or ", builder, subFilters);
        }

        public StringBuilder visitCompositeFilter(String operation, StringBuilder builder, List<QueryFilter<Object>> subFilters) {
            builder.append('(');
            boolean first = true;
            for (QueryFilter<Object> subfilter : subFilters) {
                if (!first) {
                    builder.append(operation);
                } else {
                    first = false;
                }
                subfilter.accept(this, builder);
            }
            return builder.append(')');
        }

        @Override
        public StringBuilder visitBooleanLiteralFilter(StringBuilder builder, boolean value) {
            builder.append(value);
            return builder;
        }

        @Override
        public StringBuilder visitContainsFilter(StringBuilder builder, Object field, Object valueAssertion) {
            return this.visitExtendedMatchFilter(builder, field, "co", valueAssertion);
        }

        @Override
        public StringBuilder visitEqualsFilter(StringBuilder builder, Object field, Object valueAssertion) {
            return this.visitExtendedMatchFilter(builder, field, "eq", valueAssertion);
        }

        @Override
        public StringBuilder visitExtendedMatchFilter(StringBuilder builder, Object field, String operator, Object valueAssertion) {
            builder.append(field.toString()).append(" ").append(operator).append(" ");
            if (valueAssertion instanceof Boolean || valueAssertion instanceof Number) {
                builder.append(valueAssertion);
            } else {
                builder.append('\"');
                builder.append(valueAssertion);
                builder.append('\"');
            }
            return builder;
        }

        @Override
        public StringBuilder visitGreaterThanFilter(StringBuilder builder, Object field, Object valueAssertion) {
            return this.visitExtendedMatchFilter(builder, field, "gt", valueAssertion);
        }

        @Override
        public StringBuilder visitGreaterThanOrEqualToFilter(StringBuilder builder, Object field, Object valueAssertion) {
            return this.visitExtendedMatchFilter(builder, field, "ge", valueAssertion);
        }

        @Override
        public StringBuilder visitLessThanFilter(StringBuilder builder, Object field, Object valueAssertion) {
            return this.visitExtendedMatchFilter(builder, field, "lt", valueAssertion);
        }

        @Override
        public StringBuilder visitLessThanOrEqualToFilter(StringBuilder builder, Object field, Object valueAssertion) {
            return this.visitExtendedMatchFilter(builder, field, "le", valueAssertion);
        }

        @Override
        public StringBuilder visitStartsWithFilter(StringBuilder builder, Object field, Object valueAssertion) {
            return this.visitExtendedMatchFilter(builder, field, "sw", valueAssertion);
        }

        @Override
        public StringBuilder visitNotFilter(StringBuilder builder, QueryFilter<Object> subFilter) {
            builder.append("! (");
            subFilter.accept(this, builder);
            return builder.append(')');
        }

        @Override
        public StringBuilder visitPresentFilter(StringBuilder builder, Object field) {
            return builder.append(field.toString()).append(" pr");
        }
    };
    private static final QueryFilter ALWAYS_FALSE = new QueryFilter(new BooleanLiteralImpl(false));
    private static final QueryFilter ALWAYS_TRUE = new QueryFilter(new BooleanLiteralImpl(true));
    protected final Impl<F> pimpl;
    private final QueryFilterVisitor<StringBuilder, StringBuilder, F> toStringVisitor;

    public static <FF> QueryFilter<FF> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static <FF> QueryFilter<FF> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <FF> QueryFilter<FF> and(Collection<QueryFilter<FF>> subFilters) {
        switch (subFilters.size()) {
            case 0: {
                return QueryFilter.alwaysTrue();
            }
            case 1: {
                return subFilters.iterator().next();
            }
        }
        return new QueryFilter(new AndImpl(Collections.unmodifiableList(new ArrayList<QueryFilter<FF>>(subFilters))));
    }

    @SafeVarargs
    public static <FF> QueryFilter<FF> and(QueryFilter<FF> ... subFilters) {
        return QueryFilter.and(Arrays.asList(subFilters));
    }

    public static <FF> QueryFilter<FF> comparisonFilter(FF field, String operator, Object valueAssertion) {
        if (operator.equalsIgnoreCase("eq")) {
            return QueryFilter.equalTo(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("gt")) {
            return QueryFilter.greaterThan(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("ge")) {
            return QueryFilter.greaterThanOrEqualTo(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("lt")) {
            return QueryFilter.lessThan(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("le")) {
            return QueryFilter.lessThanOrEqualTo(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("co")) {
            return QueryFilter.contains(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("sw")) {
            return QueryFilter.startsWith(field, valueAssertion);
        }
        if (operator.matches("[a-zA-Z_0-9.]+")) {
            return new QueryFilter(new ExtendedMatchImpl(field, operator, valueAssertion));
        }
        throw new IllegalArgumentException("\"" + operator + "\" is not a valid filter operator");
    }

    public static <FF> QueryFilter<FF> contains(FF field, Object valueAssertion) {
        return new QueryFilter(new ContainsImpl(field, valueAssertion));
    }

    public static <FF> QueryFilter<FF> equalTo(FF field, Object valueAssertion) {
        return new QueryFilter(new EqualsImpl(field, valueAssertion));
    }

    public static <FF> QueryFilter<FF> greaterThan(FF field, Object valueAssertion) {
        return new QueryFilter(new GreaterThanImpl(field, valueAssertion));
    }

    public static <FF> QueryFilter<FF> greaterThanOrEqualTo(FF field, Object valueAssertion) {
        return new QueryFilter(new GreaterThanOrEqualToImpl(field, valueAssertion));
    }

    public static <FF> QueryFilter<FF> lessThan(FF field, Object valueAssertion) {
        return new QueryFilter(new LessThanImpl(field, valueAssertion));
    }

    public static <FF> QueryFilter<FF> extendedMatch(FF field, String operator, Object valueAssertion) {
        return new QueryFilter(new ExtendedMatchImpl(field, operator, valueAssertion));
    }

    public static <FF> QueryFilter<FF> lessThanOrEqualTo(FF field, Object valueAssertion) {
        return new QueryFilter(new LessThanOrEqualToImpl(field, valueAssertion));
    }

    public static <FF> QueryFilter<FF> not(QueryFilter<FF> subFilter) {
        return new QueryFilter(new NotImpl(subFilter));
    }

    public static <FF> QueryFilter<FF> or(Collection<QueryFilter<FF>> subFilters) {
        switch (subFilters.size()) {
            case 0: {
                return QueryFilter.alwaysFalse();
            }
            case 1: {
                return subFilters.iterator().next();
            }
        }
        return new QueryFilter(new OrImpl(Collections.unmodifiableList(new ArrayList<QueryFilter<FF>>(subFilters))));
    }

    @SafeVarargs
    public static <FF> QueryFilter<FF> or(QueryFilter<FF> ... subFilters) {
        return QueryFilter.or(Arrays.asList(subFilters));
    }

    public static <FF> QueryFilter<FF> present(FF field) {
        return new QueryFilter(new PresentImpl(field));
    }

    public static <FF> QueryFilter<FF> startsWith(FF field, Object valueAssertion) {
        return new QueryFilter(new StartsWithImpl(field, valueAssertion));
    }

    protected QueryFilter(Impl<F> pimpl) {
        this(pimpl, TO_STRING_VISITOR);
    }

    protected QueryFilter(Impl<F> pimpl, QueryFilterVisitor<StringBuilder, StringBuilder, F> toStringVisitor) {
        this.pimpl = pimpl;
        this.toStringVisitor = toStringVisitor;
    }

    public <R, P> R accept(QueryFilterVisitor<R, P, F> v, P p) {
        return this.pimpl.accept(v, p);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QueryFilter) {
            return this.pimpl.equals(((QueryFilter)obj).pimpl);
        }
        return false;
    }

    public int hashCode() {
        return this.pimpl.hashCode();
    }

    public String toString() {
        return this.accept(this.toStringVisitor, new StringBuilder()).toString();
    }

    private static final class StartsWithImpl<FF>
    extends ComparatorImpl<FF> {
        private StartsWithImpl(FF field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitStartsWithFilter(p, this.field, this.valueAssertion);
        }
    }

    private static final class PresentImpl<FF>
    extends Impl<FF> {
        private final FF field;

        private PresentImpl(FF field) {
            this.field = field;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PresentImpl) {
                PresentImpl o = (PresentImpl)obj;
                return this.field.equals(o.field);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.field.hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitPresentFilter(p, this.field);
        }

        public String toString() {
            return this.field.toString() + " pr";
        }
    }

    private static final class OrImpl<FF>
    extends Impl<FF> {
        private final List<QueryFilter<FF>> subFilters;

        private OrImpl(List<QueryFilter<FF>> subFilters) {
            this.subFilters = subFilters;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OrImpl) {
                return this.subFilters.equals(((OrImpl)obj).subFilters);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.subFilters.hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitOrFilter(p, this.subFilters);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Or(");
            boolean isFirst = true;
            for (QueryFilter<FF> subFilter : this.subFilters) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(",");
                }
                builder.append(subFilter.pimpl.toString());
            }
            builder.append(')');
            return builder.toString();
        }
    }

    private static final class NotImpl<FF>
    extends Impl<FF> {
        private final QueryFilter<FF> subFilter;

        private NotImpl(QueryFilter<FF> subFilter) {
            this.subFilter = subFilter;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NotImpl) {
                return this.subFilter.equals(((NotImpl)obj).subFilter);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.subFilter.hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitNotFilter(p, this.subFilter);
        }

        public String toString() {
            return "Not(" + this.subFilter.pimpl.toString() + ")";
        }
    }

    private static final class LessThanOrEqualToImpl<FF>
    extends ComparatorImpl<FF> {
        private LessThanOrEqualToImpl(FF field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitLessThanOrEqualToFilter(p, this.field, this.valueAssertion);
        }
    }

    private static final class LessThanImpl<FF>
    extends ComparatorImpl<FF> {
        private LessThanImpl(FF field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitLessThanFilter(p, this.field, this.valueAssertion);
        }
    }

    private static abstract class Impl<FF> {
        protected Impl() {
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        protected abstract <R, P> R accept(QueryFilterVisitor<R, P, FF> var1, P var2);
    }

    private static final class GreaterThanOrEqualToImpl<FF>
    extends ComparatorImpl<FF> {
        private GreaterThanOrEqualToImpl(FF field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitGreaterThanOrEqualToFilter(p, this.field, this.valueAssertion);
        }
    }

    private static final class GreaterThanImpl<FF>
    extends ComparatorImpl<FF> {
        private GreaterThanImpl(FF field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitGreaterThanFilter(p, this.field, this.valueAssertion);
        }
    }

    private static final class ExtendedMatchImpl<FF>
    extends ComparatorImpl<FF> {
        private final String operator;

        private ExtendedMatchImpl(FF field, String operator, Object valueAssertion) {
            super(field, valueAssertion);
            this.operator = operator;
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitExtendedMatchFilter(p, this.field, this.operator, this.valueAssertion);
        }

        @Override
        public int hashCode() {
            return (this.field.hashCode() * 31 + this.operator.hashCode()) * 31 + this.valueAssertion.hashCode();
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.field.toString() + "," + this.operator + "," + this.valueAssertion + "]";
        }
    }

    private static final class EqualsImpl<FF>
    extends ComparatorImpl<FF> {
        private EqualsImpl(FF field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitEqualsFilter(p, this.field, this.valueAssertion);
        }
    }

    private static final class ContainsImpl<FF>
    extends ComparatorImpl<FF> {
        private ContainsImpl(FF field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitContainsFilter(p, this.field, this.valueAssertion);
        }
    }

    private static abstract class ComparatorImpl<FF>
    extends Impl<FF> {
        protected final FF field;
        protected final Object valueAssertion;

        protected ComparatorImpl(FF field, Object valueAssertion) {
            this.field = field;
            this.valueAssertion = valueAssertion;
        }

        @Override
        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ComparatorImpl) {
                ComparatorImpl o = (ComparatorImpl)obj;
                return this.field.equals(o.field) && this.getClass().equals(o.getClass()) && this.valueAssertion.equals(o.valueAssertion);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.field.hashCode() * 31 + this.getClass().hashCode()) * 31 + this.valueAssertion.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.field.toString() + "," + this.valueAssertion + "]";
        }
    }

    private static final class BooleanLiteralImpl<FF>
    extends Impl<FF> {
        private final boolean value;

        private BooleanLiteralImpl(boolean value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BooleanLiteralImpl) {
                return this.value == ((BooleanLiteralImpl)obj).value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Boolean.valueOf(this.value).hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitBooleanLiteralFilter(p, this.value);
        }

        public String toString() {
            return "BooleanLiteral(" + this.value + ")";
        }
    }

    private static final class AndImpl<FF>
    extends Impl<FF> {
        private final List<QueryFilter<FF>> subFilters;

        private AndImpl(List<QueryFilter<FF>> subFilters) {
            this.subFilters = subFilters;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AndImpl) {
                return this.subFilters.equals(((AndImpl)obj).subFilters);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.subFilters.hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P, FF> v, P p) {
            return v.visitAndFilter(p, this.subFilters);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("And(");
            boolean isFirst = true;
            for (QueryFilter<FF> subFilter : this.subFilters) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(",");
                }
                builder.append(subFilter.pimpl.toString());
            }
            builder.append(')');
            return builder.toString();
        }
    }
}

