/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.generator;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.forgerock.util.annotations.VisibleForTesting;

public interface IdGenerator {
    public static final IdGenerator DEFAULT = new SequenceUuidIdGenerator(UUID.randomUUID());

    public String generate();

    public static final class SequenceUuidIdGenerator
    implements IdGenerator {
        private final String prefix;
        private final AtomicLong sequence = new AtomicLong();

        @VisibleForTesting
        SequenceUuidIdGenerator(UUID uuid) {
            this.prefix = uuid.toString();
        }

        @Override
        public String generate() {
            return this.prefix + '-' + this.sequence.getAndIncrement();
        }
    }
}

