/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.security.keystore;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import org.forgerock.security.keystore.KeyStoreType;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyStoreBuilder {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreBuilder.class);
    private KeyStoreType type = KeyStoreType.JKS;
    private KeyStore.LoadStoreParameter loadStoreParameter;
    private InputStream inputStream;
    private Provider provider;
    private char[] password;

    public KeyStoreBuilder withInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public KeyStoreBuilder withKeyStoreFile(File keyStoreFile) throws FileNotFoundException {
        Reject.ifNull((Object)keyStoreFile);
        return this.withInputStream(new FileInputStream(keyStoreFile));
    }

    public KeyStoreBuilder withKeyStoreFile(String keyStoreFile) throws FileNotFoundException {
        if (this.isBlank(keyStoreFile)) {
            return this.withInputStream(null);
        }
        return this.withInputStream(new FileInputStream(keyStoreFile));
    }

    public KeyStoreBuilder withKeyStoreType(KeyStoreType type) {
        this.type = (KeyStoreType)((Object)Reject.checkNotNull((Object)((Object)type)));
        return this;
    }

    public KeyStoreBuilder withPassword(char[] password) {
        this.password = password;
        return this;
    }

    public KeyStoreBuilder withPassword(String password) {
        return this.withPassword(password.toCharArray());
    }

    public KeyStoreBuilder withProvider(Provider provider) {
        this.provider = (Provider)Reject.checkNotNull((Object)provider);
        return this;
    }

    public KeyStoreBuilder withProvider(String providerName) {
        if (this.isBlank(providerName)) {
            return this;
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new IllegalArgumentException("No such provider: " + providerName);
        }
        return this.withProvider(provider);
    }

    public KeyStoreBuilder withLoadStoreParameter(KeyStore.LoadStoreParameter loadStoreParameter) {
        Reject.ifNull((Object)loadStoreParameter);
        this.loadStoreParameter = loadStoreParameter;
        return this;
    }

    public KeyStore build() {
        KeyStore keyStore;
        try {
            KeyStore keyStore2;
            KeyStore keyStore3 = keyStore2 = this.provider != null ? KeyStore.getInstance(this.type.toString(), this.provider) : KeyStore.getInstance(this.type.toString());
            if (this.inputStream != null && this.loadStoreParameter != null) {
                throw new IllegalStateException("Can not specify a load store parameter and an input stream");
            }
            if (this.loadStoreParameter != null) {
                keyStore2.load(this.loadStoreParameter);
            } else if (KeyStoreType.PKCS11.equals((Object)this.type)) {
                keyStore2.load(null, this.password);
            } else {
                keyStore2.load(this.inputStream, this.password);
            }
            keyStore = keyStore2;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            try {
                logger.error("Error loading keystore", (Throwable)e);
                throw new IllegalStateException("Unable to load keystore", e);
            }
            catch (Throwable throwable) {
                Utils.closeSilently((Closeable[])new Closeable[]{this.inputStream});
                throw throwable;
            }
        }
        Utils.closeSilently((Closeable[])new Closeable[]{this.inputStream});
        return keyStore;
    }

    private boolean isBlank(CharSequence charSeq) {
        if (charSeq == null) {
            return true;
        }
        int length = charSeq.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(charSeq.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

