/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws.handlers;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.forgerock.json.jose.exceptions.JwsSigningException;
import org.forgerock.json.jose.exceptions.JwsVerifyingException;
import org.forgerock.json.jose.jws.JwsAlgorithm;
import org.forgerock.json.jose.jws.JwsAlgorithmType;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.utils.Utils;
import org.forgerock.util.Reject;
import org.forgerock.util.SignatureUtil;

public class RSASigningHandler
implements SigningHandler {
    private final SignatureUtil signatureUtil;
    private final Key key;

    public RSASigningHandler(Key key, SignatureUtil signatureUtil) {
        this.key = key;
        this.signatureUtil = signatureUtil;
    }

    @Override
    public byte[] sign(JwsAlgorithm algorithm, String data) {
        this.validateAlgorithm(algorithm);
        try {
            Reject.ifFalse((boolean)(this.key instanceof PrivateKey), (String)"RSA requires private key for signing.");
            return this.signatureUtil.sign((PrivateKey)this.key, algorithm.getAlgorithm(), data);
        }
        catch (SignatureException e) {
            if (e.getCause() != null && e.getCause().getClass().isAssignableFrom(NoSuchAlgorithmException.class)) {
                throw new JwsSigningException("Unsupported Signing Algorithm, " + algorithm.getAlgorithm(), e);
            }
            throw new JwsSigningException(e);
        }
    }

    @Override
    public byte[] sign(JwsAlgorithm algorithm, byte[] data) {
        this.validateAlgorithm(algorithm);
        try {
            Reject.ifFalse((boolean)(this.key instanceof PrivateKey), (String)"RSA requires private key for signing.");
            Signature signature = Signature.getInstance(algorithm.getAlgorithm());
            signature.initSign((PrivateKey)this.key);
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new JwsSigningException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JwsSigningException("Unsupported Signing Algorithm, " + algorithm.getAlgorithm(), e);
        }
    }

    @Override
    public boolean verify(JwsAlgorithm algorithm, byte[] data, byte[] signature) {
        this.validateAlgorithm(algorithm);
        try {
            Reject.ifFalse((boolean)(this.key instanceof PublicKey), (String)"RSA requires public key for signature verification.");
            return this.signatureUtil.verify((PublicKey)this.key, algorithm.getAlgorithm(), new String(data, Utils.CHARSET), signature);
        }
        catch (SignatureException e) {
            if (e.getCause() != null && e.getCause().getClass().isAssignableFrom(NoSuchAlgorithmException.class)) {
                throw new JwsVerifyingException("Unsupported Signing Algorithm, " + algorithm.getAlgorithm(), e);
            }
            throw new JwsVerifyingException(e);
        }
    }

    private void validateAlgorithm(JwsAlgorithm algorithm) {
        Reject.ifNull((Object)algorithm, (String)"Algorithm must not be null.");
        Reject.ifTrue((algorithm.getAlgorithmType() != JwsAlgorithmType.RSA ? 1 : 0) != 0, (String)"Not an RSA algorithm.");
    }
}

